#include "SETUP.h"

extern PwmOut Servo;
extern PwmOut Cutter_1;
extern PwmOut Cutter_2;
extern PwmOut Spleisser_1;
extern PwmOut Spleisser_2;

float duty1 = (GOOD_FIL*0.2666666+22.5)/100;
float duty2 = (BAD_FIL*0.2666666+22.5)/100;


/* ---------------------------- SERVO --------------------------------------- */
void Init_Servo()
{
    Servo.period(1/(float)SERVO_FR);
    Servo = 0.0;
}

void Set_Servo_Good_Fil()
{
    Servo.period(1/(float)SERVO_FR);
    Servo = duty1;
}

void Set_Servo_Bad_Fil()
{
    Servo.period(1/(float)SERVO_FR);
    Servo = duty2;
}
void Servo_Off()
{
    Thread::wait(250);
    Servo.period(1/(float)SERVO_FR);
    Servo = 0.0;
}

/* ---------------------------- END ----------------------------------------- */



/* ---------------------------- CUTTER -------------------------------------- */
void Init_Cutter()
{
    Cutter_1.period(1/(float)CUTTER_FRQ_1);
    Cutter_1 = 0.0;
    
    Cutter_2.period(1/(float)CUTTER_FRQ_2);
    Cutter_2 = 0.0;
}
    
void Set_Cutter(int arc_on_time, int arc_off_time, int repeats)
{
    Cutter_1.period(1/(float)CUTTER_FRQ_1);
    Cutter_2.period(1/(float)CUTTER_FRQ_2);
    
    for(int i = repeats; i>0; i--)
    {
        Cutter_1 = (float)CUTTER_DUTY/100;
        Cutter_2 = (float)CUTTER_DUTY/100;
        Thread::wait(arc_on_time);
        Cutter_1 = 0.0;
        Cutter_2 = 0.0;
        Thread::wait(arc_off_time);
    }
    Cutter_1 = 0.0;
    Cutter_2 = 0.0;
}
/* ---------------------------- END ----------------------------------------- */



/* ---------------------------- SPLEISSER ----------------------------------- */
void Init_Spleisser()
{
    Spleisser_1.period(1/(float)SPLEISSER_FRQ_1);
    Spleisser_1 = 0.0;
    
    Spleisser_2.period(1/(float)SPLEISSER_FRQ_2);
    Spleisser_2 = 0.0;
}

void Set_Spleisser(int arc_on_time, int arc_off_time, int repeats)
{
    Spleisser_1.period(1/(float)SPLEISSER_FRQ_1);
    Spleisser_2.period(1/(float)SPLEISSER_FRQ_2);
    
    for(int i = repeats; i>0; i--)
    {
        Spleisser_1 = (float)SPLEISSER_DUTY/100;
        Spleisser_2 = (float)SPLEISSER_DUTY/100;
        Thread::wait(arc_on_time);
        Spleisser_1 = 0.0;
        Spleisser_2 = 0.0;
        Thread::wait(arc_off_time);
    }
    Spleisser_1 = 0.0;
    Spleisser_2 = 0.0;
}
/* ---------------------------- END ----------------------------------------- */