/* ------------------------ INCLUDE ----------------------------------------- */
#include "SETUP.h"

/* ---------------------------- END ----------------------------------------- */


/* Zum testen */
DigitalOut myled(LED1);
DigitalIn  mybutton(USER_BUTTON);



/* ----------------------- INITIALISIERUNG ---------------------------------- */
/* -------------------------------------------------------------------------- */

/* Status Spleisser definieren*/
int StatusSpleisser = ST_SOLO;

extern int StatusDUO;
extern int StatusSOLO;


/*Buttons initialisieren*/

//InterruptIn buttonSTART(START_BUTTON);
DigitalIn Button1(START_BUTTON);
volatile bool buttonSTART_pressed = false; // Used in the main loop
volatile bool buttonSTART_enabled = true;  // Used for debouncing
Timeout buttonSTART_timeout;               // Used for debouncing

//InterruptIn buttonAbbruch(ABBRUCH_BUTTON);
DigitalIn Button2(ABBRUCH_BUTTON);
volatile bool buttonAbbruch_pressed = false; // Used in the main loop
volatile bool buttonAbbruch_enabled = true;  // Used for debouncing
Timeout buttonAbbruch_timeout;               // Used for debouncing


/*PWMs initialisieren*/
PwmOut Servo        (SERVO_PWM);
PwmOut Cutter_1     (CUTTER_ARC_1);
PwmOut Cutter_2     (CUTTER_ARC_2);
PwmOut Spleisser_1  (SPLEISSER_ARC_1);
PwmOut Spleisser_2  (SPLEISSER_ARC_2);

/*Lichtschranken*/
DigitalIn LS_1(LICHTSCHRANKE_1);  // HIGH - kein Filament / LOW - Filament
DigitalIn LS_2(LICHTSCHRANKE_2);  // HIGH - kein Filament / LOW - Filament  /* Mit LS_x.read(); auslesen */
DigitalIn LS_3(LICHTSCHRANKE_3);  // HIGH - kein Filament / LOW - Filament

/*Input initalisieren für Status Spleisser*/
DigitalIn InputKontrollmodul(COM_SIGNAL);
int val_InputKontrollmodul = 0;

DigitalIn CutSignal(CUT_SIGNAL);
/* Motor Control Expansion Board. */
XNucleoIHM02A1 *x_nucleo_ihm02a1_1;
XNucleoIHM02A12 *x_nucleo_ihm02a1_2;

/* Initialization parameters of the motors connected to the expansion board. */
L6470_init_t init[L6470DAISYCHAINSIZE] = {
    /* First Motor. */
    {
        12.0,                          /* Motor supply voltage in V. */
        400,                           /* Min number of steps per revolution for the motor. */
        1.7,                           /* Max motor phase voltage in A. */
        3.06,                          /* Max motor phase voltage in V. */
        300.0,                         /* Motor initial speed [step/s]. */
        500.0,                         /* Motor acceleration [step/s^2] (comment for infinite acceleration mode). */
        500.0,                         /* Motor deceleration [step/s^2] (comment for infinite deceleration mode). */
        992.0,                         /* Motor maximum speed [step/s]. */
        0.0,                           /* Motor minimum speed [step/s]. */
        602.7,                         /* Motor full-step speed threshold [step/s]. */
        3.06,                          /* Holding kval [V]. */
        3.06,                          /* Constant speed kval [V]. */
        3.06,                          /* Acceleration starting kval [V]. */
        3.06,                          /* Deceleration starting kval [V]. */
        61.52,                         /* Intersect speed for bemf compensation curve slope changing [step/s]. */
        392.1569e-6,                   /* Start slope [s/step]. */
        643.1372e-6,                   /* Acceleration final slope [s/step]. */
        643.1372e-6,                   /* Deceleration final slope [s/step]. */
        0,                             /* Thermal compensation factor (range [0, 15]). */
        3.06 * 1000 * 1.10,            /* Ocd threshold [ma] (range [375 ma, 6000 ma]). */
        3.06 * 1000 * 1.00,            /* Stall threshold [ma] (range [31.25 ma, 4000 ma]). */
        StepperMotor::STEP_MODE_1_128, /* Step mode selection. */
        0xFF,                          /* Alarm conditions enable. */
        0x2E88                         /* Ic configuration. */
    },

    /* Second Motor. */
    {
        12.0,                           /* Motor supply voltage in V. */
        400,                           /* Min number of steps per revolution for the motor. */
        1.7,                           /* Max motor phase voltage in A. */
        3.06,                          /* Max motor phase voltage in V. */
        300.0,                         /* Motor initial speed [step/s]. */
        500.0,                         /* Motor acceleration [step/s^2] (comment for infinite acceleration mode). */
        500.0,                         /* Motor deceleration [step/s^2] (comment for infinite deceleration mode). */
        992.0,                         /* Motor maximum speed [step/s]. */
        0.0,                           /* Motor minimum speed [step/s]. */
        602.7,                         /* Motor full-step speed threshold [step/s]. */
        3.06,                          /* Holding kval [V]. */
        3.06,                          /* Constant speed kval [V]. */
        3.06,                          /* Acceleration starting kval [V]. */
        3.06,                          /* Deceleration starting kval [V]. */
        61.52,                         /* Intersect speed for bemf compensation curve slope changing [step/s]. */
        392.1569e-6,                   /* Start slope [s/step]. */
        643.1372e-6,                   /* Acceleration final slope [s/step]. */
        643.1372e-6,                   /* Deceleration final slope [s/step]. */
        0,                             /* Thermal compensation factor (range [0, 15]). */
        3.06 * 1000 * 1.10,            /* Ocd threshold [ma] (range [375 ma, 6000 ma]). */
        3.06 * 1000 * 1.00,            /* Stall threshold [ma] (range [31.25 ma, 4000 ma]). */
        StepperMotor::STEP_MODE_1_128, /* Step mode selection. */
        0xFF,                          /* Alarm conditions enable. */
        0x2E88                         /* Ic configuration. */
    }
};

/* Motor Objekte */
L6470B **motors2;
L6470 **motors;

/* --------------------------------- END ------------------------------------ */
/* -------------------------------------------------------------------------- */






/* ------------------------------- BOOT SCREEN ------------------------------ */
void Boot_Screen()
{

    DisplaySendeBefehl(0x01);
    DisplaySendeBefehl(0x0C);
    gotoxy(1, 1);
    DisplaySendeString("BOOT:");
    gotoxy(1, 3);
    DisplaySendeString("SPLEISSER FIRMWARE");
    
    gotoxy(1, 4);
    DisplaySendeString("[        0%        ]");
    Thread::wait((BOOTTIME/14)*1000);
    gotoxy(1, 4);
    DisplaySendeString("[-       7%        ]");
    Thread::wait((BOOTTIME/14)*1000);
    gotoxy(1, 4);
    DisplaySendeString("[--     14%        ]");
    Thread::wait((BOOTTIME/14)*1000);
    gotoxy(1, 4);
    DisplaySendeString("[---    21%        ]");
    Thread::wait((BOOTTIME/14)*1000);
    gotoxy(1, 4);
    DisplaySendeString("[----   28%        ]");
    Thread::wait((BOOTTIME/14)*1000);
    gotoxy(1, 4);
    DisplaySendeString("[-----  35%        ]");
    Thread::wait((BOOTTIME/14)*1000);
    gotoxy(1, 4);
    DisplaySendeString("[------ 42%        ]");
    Thread::wait((BOOTTIME/14)*1000);
    gotoxy(1, 4);
    DisplaySendeString("[-------49%        ]");
    Thread::wait((BOOTTIME/14)*1000);
    gotoxy(1, 4);
    DisplaySendeString("[-------56%-       ]");
    Thread::wait((BOOTTIME/14)*1000);
    gotoxy(1, 4);
    DisplaySendeString("[-------63%--      ]");
    Thread::wait((BOOTTIME/14)*1000);
    gotoxy(1, 4);
    DisplaySendeString("[-------70%---     ]");
    Thread::wait((BOOTTIME/14)*1000);
    gotoxy(1, 4);
    DisplaySendeString("[-------77%----    ]");
    Thread::wait((BOOTTIME/14)*1000);
    gotoxy(1, 4);
    DisplaySendeString("[-------84%-----   ]");
    Thread::wait((BOOTTIME/14)*1000);
    gotoxy(1, 4);
    DisplaySendeString("[-------91%------  ]");
    Thread::wait((BOOTTIME/14)*1000);
    gotoxy(1, 4);
    DisplaySendeString("[-------98%------- ]");
    Thread::wait((BOOTTIME/14)*1000);
    gotoxy(1, 4);
    DisplaySendeString("[-------100%-------]");
    Thread::wait(500);
}
/* --------------------------------- END ------------------------------------ */







/* ---------------------------------- MAIN ---------------------------------- */
/* -------------------------------------------------------------------------- */

int main()
{

    /* Initializing Motor Control Expansion Board. */
    x_nucleo_ihm02a1_1 = new XNucleoIHM02A1 (&init[0], &init[1], IRQ_FLAG_MOTOR, IRQ_BUSY_MOTOR, STB_MOTOR, SPI_CS_1, SPI_MOSI, SPI_MISO, SPI_CLK );
    x_nucleo_ihm02a1_2 = new XNucleoIHM02A12(&init[0], &init[1], IRQ_FLAG_MOTOR, IRQ_BUSY_MOTOR, STB_MOTOR, SPI_CS_2, SPI_MOSI, SPI_MISO, SPI_CLK );

    /* Building a list of motor control components. */
    motors2 = x_nucleo_ihm02a1_2->get_components();
    motors =  x_nucleo_ihm02a1_1->get_components();

    /* Attach ISR to handle button press event
    buttonSTART.fall(callback(buttonSTART_onpressed_cb));
    buttonAbbruch.fall(callback(buttonAbbruch_onpressed_cb));
    */
    /* Init PWM */
    Init_Servo();
    Init_Cutter();
    Init_Spleisser();

    /*Display*/
    wait_ms(250);
    DisplayInit();



    Boot_Screen();


    /* -------------------- ---- STATE_MACHINE ------------------------------ */
    while(1) {
        val_InputKontrollmodul=InputKontrollmodul;
      //  printf("%i",val_InputKontrollmodul);
        
       //val_InputKontrollmodul = InputKontrollmodul.read();
        switch (StatusSpleisser) {
            case ST_SOLO:
                if(InputKontrollmodul == 0) 
                {
                    EntrySOLO();
                } 
                else if(InputKontrollmodul == 1)
                {
                    StatusDUO =DUO_DEFAULT;
                    StatusSpleisser = ST_DUO;
                }
                break;
            case ST_DUO:
                if(InputKontrollmodul == 1) {
                    
                    EntryDUO();
                } 
                else if (InputKontrollmodul == 0)
                {
                    StatusSOLO =SOLO_DEFAULT;
                    StatusSpleisser = ST_SOLO;
                }
                break;     
        }
       
    }
    /* ------------------------------ END ----------------------------------- */




}
/* --------------------------------- END ------------------------------------ */
/* -------------------------------------------------------------------------- */