#include "SETUP.h"
/* --------------------------- Variables ------------------------------------ */
extern L6470B **motors2;
extern L6470 **motors;
/* ---------------------------- END ----------------------------------------- */



/* -------------------------- Leerlauf -------------------------------------- */
void Stepper_1_Leerlauf()
{
    motors[0]->hard_hiz();
    motors[0]->wait_while_active();
}
void Stepper_2_Leerlauf()
{
    motors[1]->hard_hiz();
    motors[1]->wait_while_active();
}
void Stepper_3_Leerlauf()
{
    motors2[0]->hard_hiz();
    motors2[0]->wait_while_active();
}
void Stepper_4_Leerlauf()
{
    motors2[1]->hard_hiz();
    motors2[1]->wait_while_active();
}
/* ---------------------------- END ----------------------------------------- */



/* --------------------------- Stop ----------------------------------------- */
void Stepper_1_Stop()
{
    motors[0]->hard_stop();
    motors[0]->wait_while_active();
}
void Stepper_2_Stop()
{
    motors[1]->hard_stop();
    motors[1]->wait_while_active();
}
void Stepper_3_Stop()
{
    motors2[0]->hard_stop();
    motors2[0]->wait_while_active();
}
void Stepper_4_Stop()
{
    motors2[1]->hard_stop();
    motors2[1]->wait_while_active();
}
/* ---------------------------- END ----------------------------------------- */



/* ---------------------- Setzte Home Position ------------------------------ */
void Stepper_1_SetHome()
{
    motors[0]->set_home();
    motors[0]->wait_while_active();
}
void Stepper_2_SetHome()
{
    motors[1]->set_home();
    motors[1]->wait_while_active();
}
void Stepper_3_SetHome()
{
    motors2[0]->set_home();
    motors2[0]->wait_while_active();
}
void Stepper_4_SetHome()
{
    motors2[1]->set_home();
    motors2[1]->wait_while_active();
}
/* ---------------------------- END ----------------------------------------- */



/* -------- Setting the current position to be the marked position ---------- */
void Stepper_1_MarkPos()
{
    motors[0]->set_mark();
    motors[0]->wait_while_active();
}
void Stepper_2_MarkPos()
{
    motors[1]->set_mark();
    motors[1]->wait_while_active();
}
void Stepper_3_MarkPos()
{
    motors2[0]->set_mark();
    motors2[0]->wait_while_active();
}
void Stepper_4_MarkPos()
{
    motors2[1]->set_mark();
    motors2[1]->wait_while_active();
}
/* ---------------------------- END ----------------------------------------- */



/* ------------------------ Get Current Position ---------------------------- */
int Stepper_1_GetPosition()
{
    return motors[0]->get_position();
}
int Stepper_2_GetPosition()
{
    return motors[1]->get_position();
}
int Stepper_3_GetPosition()
{
    return motors2[0]->get_position();
}
int Stepper_4_GetPosition()
{
    return motors2[1]->get_position();
}
/* ---------------------------- END ----------------------------------------- */



/* ---------------------- Get Marked Position ------------------------------- */

int Stepper_1_GetMark()
{
    return motors[0]->get_mark();
}
int Stepper_2_GetMark()
{
    return motors[1]->get_mark();
}
int Stepper_3_GetMark()
{
    return motors2[0]->get_mark();
}
int Stepper_4_GetMark()
{
    return motors2[1]->get_mark();
}

/* ---------------------------- END ----------------------------------------- */



/* ------------------ Going to a specified position ------------------------- */
void Stepper_1_GoTo(signed int position)
{
    motors[0]->go_to(position);
    motors[0]->wait_while_active();
}
void Stepper_2_GoTo(signed int position)
{
    motors[1]->go_to(position);
    motors[1]->wait_while_active();
}
void Stepper_3_GoTo(signed int position)
{
    motors2[0]->go_to(position);
    motors2[0]->wait_while_active();
}
void Stepper_4_GoTo(signed int position)
{
    motors2[1]->go_to(position);
    motors2[1]->wait_while_active();
}
/* ---------------------------- END ----------------------------------------- */



/* ------------------------- Go to Home ------------------------------------- */
void Stepper_1_GoHome()
{
    motors[0]->go_home();
    motors[0]->wait_while_active();
}
void Stepper_2_GoHome()
{
    motors[1]->go_home();
    motors[1]->wait_while_active();
}
void Stepper_3_GoHome()
{
    motors2[0]->go_home();
    motors2[0]->wait_while_active();
}
void Stepper_4_GoHome()
{
    motors[1]->go_home();
    motors[1]->wait_while_active();
}
/* ---------------------------- END ----------------------------------------- */



/* ----------------------------- Go to Mark --------------------------------- */
void Stepper_1_GoMark()
{
    motors[0]->go_mark();
    motors[0]->wait_while_active();
}
void Stepper_2_GoMark()
{
    motors[1]->go_mark();
    motors[1]->wait_while_active();
}
void Stepper_3_GoMark()
{
    motors2[0]->go_mark();
    motors2[0]->wait_while_active();
}
void Stepper_4_GoMark()
{
    motors2[1]->go_mark();
    motors2[1]->wait_while_active();
}
/* ---------------------------- END ----------------------------------------- */



/* --------------------------------- MOVE ----------------------------------- */
void Stepper_1_Move(char direction, unsigned int steps)
{
    if( direction == 'V') {
        motors[0]->move(StepperMotor::FWD, 128*steps);
        motors[0]->wait_while_active();
    } else if ( direction == 'R') {
        motors[0]->move(StepperMotor::BWD, 128*steps);
        motors[0]->wait_while_active();
    }

}
void Stepper_2_Move(char direction, unsigned int steps)
{
    if( direction == 'V') {
        motors[1]->move(StepperMotor::FWD, 128*steps);
        motors[1]->wait_while_active();
    } else if ( direction == 'R') {
        motors[1]->move(StepperMotor::BWD, 128*steps);
        motors[1]->wait_while_active();
    }
}
void Stepper_3_Move(char direction, unsigned int steps)
{
    if( direction == 'V') {
        motors2[0]->move(StepperMotor::FWD, 128*steps);
        motors2[0]->wait_while_active();
    } else if ( direction == 'R') {
        motors2[0]->move(StepperMotor::BWD, 128*steps);
        motors2[0]->wait_while_active();
    }
}
void Stepper_4_Move(char direction, unsigned int steps)
{
    if( direction == 'V') {
        motors2[1]->move(StepperMotor::FWD, 128*steps);
        motors2[1]->wait_while_active();
    } else if ( direction == 'R') {
        motors2[1]->move(StepperMotor::BWD, 128*steps);
        motors2[1]->wait_while_active();
    }
}
/* ---------------------------- END ----------------------------------------- */



/* --------------------------------- RUN ------------------------------------ */
void Stepper_1_Run(char direction, unsigned int speed)
{
    if( direction == 'V') {
        motors[0]->run(StepperMotor::FWD, speed);
        motors[0]->wait_while_active();
    } else if ( direction == 'R') {
        motors[0]->run(StepperMotor::BWD, speed);
        motors[0]->wait_while_active();
    }

}
void Stepper_2_Run(char direction, unsigned int speed)
{
    if( direction == 'V') {
        motors[1]->run(StepperMotor::FWD, speed);
        motors[1]->wait_while_active();
    } else if ( direction == 'R') {
        motors[1]->run(StepperMotor::BWD, speed);
        motors[1]->wait_while_active();
    }
}
void Stepper_3_Run(char direction, unsigned int speed)
{
    if( direction == 'V') {
        motors2[0]->run(StepperMotor::FWD, speed);
        motors2[0]->wait_while_active();
    } else if ( direction == 'R') {
        motors2[0]->run(StepperMotor::BWD, speed);
        motors2[0]->wait_while_active();
    }
}
void Stepper_4_Run(char direction, unsigned int speed)
{
    if( direction == 'V') {
        motors2[1]->run(StepperMotor::FWD, speed);
        motors2[1]->wait_while_active();
    } else if ( direction == 'R') {
        motors2[1]->run(StepperMotor::BWD, speed);
        motors2[1]->wait_while_active();
    }
}
/* ---------------------------- END ----------------------------------------- */




/* ------------------------- SET_SPEED_AC ----------------------------------- */
void Stepper_1_SetPara(int speed, int acc)
{
    motors[0]->set_max_speed(speed);
    motors[0]->set_acceleration(acc);
}
void Stepper_2_SetPara(int speed, int acc)
{
    motors[1]->set_max_speed(speed);
    motors[1]->set_acceleration(acc);
}
void Stepper_3_SetPara(int speed, int acc)
{
    motors2[0]->set_max_speed(speed);
    motors2[0]->set_acceleration(acc);
}
void Stepper_4_SetPara(int speed, int acc)
{
    motors2[1]->set_max_speed(speed);
    motors2[1]->set_acceleration(acc);
}
/* ---------------------------- END ----------------------------------------- */