#include "SETUP.h"


int StatusDUO=DUO_DEFAULT;


extern DigitalIn InputKontrollmodul;
extern DigitalIn CutSignal;
extern DigitalIn FertigSignal;
int val_CutSignal = 0;
int val_FertigSignal = 0;

int Stepper1CurrentPos = 0;
int Stepper1MarkPos = 0;

bool Fertig = false;

bool Fila_Good = false;

bool ABS = false;

bool PLA = true;

bool ButtonSTART = false;
bool ButtonABBRUCH = false;

extern PwmOut Servo;

extern L6470 **motors;
extern L6470B **motors2;

extern DigitalIn LS_1;
extern DigitalIn LS_2;
extern DigitalIn LS_3;

extern PwmOut Cutter_1;
extern PwmOut Cutter_2;
extern PwmOut Spleisser_1;
extern PwmOut Spleisser_2;


bool get_InputKontrollmodul()
{     
    val_CutSignal = CutSignal.read();
     if( val_CutSignal == 1)
     {
         wait(0.01);
         if(val_CutSignal == 1)
         {
             return true;
         }   
     }
     else if(val_CutSignal == 0)
     {
         wait(0.01);
         if(val_CutSignal == 0)
         {
             return false;
         } 
     }
     else return false;
}

bool get_FertigSignal()
{     
    val_FertigSignal = FertigSignal.read();
     if( val_FertigSignal == 1)
     {
         wait(0.01);
         if(val_FertigSignal == 1)
         {
             return true;
         }   
     }
     else if(val_FertigSignal == 0)
     {
         wait(0.01);
         if(val_FertigSignal == 0)
         {
             return false;
         } 
     }
     else return false;
}

void EntryDuoDefault()
{
      StatusDUO=DUO_DEFAULT;  
}

void EntryDuoStart()
{   
    Stepper_1_Leerlauf();
    Stepper_2_Leerlauf();
    Stepper_3_Leerlauf();
    if(LS_1 == 1)
    {
        Set_Servo_Bad_Fil();
    }
    
    DisplaySendeBefehl(0x0C);
    DisplaySendeBefehl(0x01);
    gotoxy(1,1);
    DisplaySendeString("Modus: DUO-Betrieb");
    gotoxy(1,4);
    DisplaySendeString("Start            PLA");
    
    PLA = true;
    ABS = false;

    StatusDUO=DUO_START;
     
}

void EntryDuoEinlegen()
{   
    DisplaySendeBefehl(0x01);
    gotoxy(1,1);
    DisplaySendeString("Filament einlegen...");
    gotoxy(1,4);
    DisplaySendeString("             Abbruch");
    
    Set_Servo_Bad_Fil();
    
    Stepper_3_SetPara(100, 100);
    Stepper_1_SetPara(100, 100);
    Stepper_1_Run('V', 300);
    Stepper_3_Run('V', 300);
    
    StatusDUO=DUO_EINLEGEN;
}

void DuoWechselFilament()
{   
    int static x = 0;
    
    if((PLA == true)&& (x == 0))
    {
        gotoxy(1,4);
        DisplaySendeString("Start            ABS");
        
        PLA = false;
        ABS = true;
        x = 1;
    }
    
    if( (ABS == true)&& (x == 0))
    {
        gotoxy(1,4);
        DisplaySendeString("Start            PLA");
        
        PLA = true;
        ABS = false;
    }
    
    if(x == 1)
    {
        x = 0;
    } 
    wait(0.3);
    StatusDUO=DUO_START;
}

void EntryDuoFilaCut1()
{
    /*********************************
    
            CUT PROZESS 
    
    **********************************/
    DisplaySendeBefehl(0x01);
    gotoxy(1,1);
    DisplaySendeString("Filament wird  ge-");
    gotoxy(1,3);
    DisplaySendeString("schnitten");
    
    Stepper_1_Stop();
    Stepper_3_Stop();
    Stepper_3_Leerlauf();

    Stepper_3_SetPara(100, 100);
    Stepper_1_SetPara(100, 100);
 
    Set_Cutter(550, 0, 1);
    motors2[0]->move(StepperMotor::FWD, 128*400*4);
    motors[0]->move(StepperMotor::BWD, 128*400*0.3);
    Set_Cutter(650, 0, 1);
    
    DisplaySendeBefehl(0x01);
    gotoxy(1,1);
    DisplaySendeString("Filament wird  ge-");
    gotoxy(1,3);
    DisplaySendeString("schnitten");
    
    motors2[0]->wait_while_active();
    motors[0]->move(StepperMotor::FWD, 128*400*0.3);
    motors[0]->wait_while_active();
    Stepper_3_Leerlauf();
   // wait(10);
    Set_Servo_Good_Fil();
    Stepper_1_SetHome();
    Stepper_1_Run('V', 300);
  //Stepper_3_Run('V', 300);
   
    
    DisplaySendeBefehl(0x01);
    gotoxy(1,1);
    DisplaySendeString("Filament ist gut.   ");
    gotoxy(1,3);
    DisplaySendeString("Wird gefoerdert...  ");
    gotoxy(1,4);
    DisplaySendeString("             Abbruch"); 
    
    StatusDUO=DUO_FILA_CUT1;
}

void EntryDuoFilaBad1()
{   
    DisplaySendeBefehl(0x01);
    gotoxy(1,1);
    DisplaySendeString("Schlechtes Filament ");
    gotoxy(1,3);
    DisplaySendeString("erkannt.            ");
    gotoxy(1,2);
    DisplaySendeString("Wird aussortiert... ");
    gotoxy(1,4);
    DisplaySendeString("             Abbruch"); 
    
    Stepper_1_SetPara(TRAVELSPEED+100, TRAVELACC+300);
    Stepper_3_SetPara(TRAVELSPEED+100, TRAVELACC+300);
    Stepper_1_GoHome();
    Set_Servo_Bad_Fil();
    Stepper_1_Run('V', 300);
    Stepper_3_Run('V', 300);
   
    StatusDUO=DUO_FILA_BAD1;
}

void EntryDuoFilaGood2()
{
    Stepper_1_Stop();
    Stepper_1_MarkPos();
    Stepper_1_SetPara(300, 300);
    motors[0]->move(StepperMotor::FWD, 128*400*10);
    
    StatusDUO=DUO_FILA_GOOD2;
}

void EntryDuoFilaGood3()
{
    Stepper_1_Leerlauf();
    Stepper_2_SetPara(300, 300);
    Stepper_1_SetPara(300, 300);
    Stepper_2_Run('V', 300);
    Stepper_1_Run('V', 300);
    
    DisplaySendeBefehl(0x01);
    gotoxy(1,1);
    DisplaySendeString("Filament ist gut.   ");
    gotoxy(1,3);
    DisplaySendeString("Wird gefoerdert...  ");
    gotoxy(1,4);
    DisplaySendeString("             Abbruch");
    
    StatusDUO=DUO_FILA_GOOD3;
}

void EntryDuoFilaCut2()
{
    Stepper_2_Stop();
    Stepper_1_Stop();
    
    /*********************************
    
            CUT PROZESS 
    
    **********************************/
    DisplaySendeBefehl(0x01);
    gotoxy(1,1);
    DisplaySendeString("Schlechtes Filament ");
    gotoxy(1,3);
    DisplaySendeString("erkannt.            ");
    gotoxy(1,2);
    DisplaySendeString("Wird geschnitten!   ");
    
    Stepper_2_SetPara(100, 100);
    Stepper_1_SetPara(100, 100);
 
    Set_Cutter(550, 0, 1);
    motors[1]->move(StepperMotor::FWD, 128*400*4);
    motors[0]->move(StepperMotor::BWD, 128*400*0.3);
    Set_Cutter(650, 0, 1);
    
    DisplaySendeBefehl(0x01);
    gotoxy(1,1);
    DisplaySendeString("Schlechtes Filament ");
    gotoxy(1,3);
    DisplaySendeString("erkannt.            ");
    gotoxy(1,2);
    DisplaySendeString("Wird geschnitten!   ");
    
    motors[1]->wait_while_active();
    motors[0]->move(StepperMotor::FWD, 128*400*0.3);
    motors[0]->wait_while_active();
    
   // wait(10);
    Set_Servo_Good_Fil();
    Stepper_1_SetHome();
    Stepper_2_SetPara(400, 300);
   // motors[1]->move(StepperMotor::FWD, 128*400*);
   // motors[1]->wait_while_active();
    Stepper_2_Run('V', 150);
   
    
    StatusDUO=DUO_FILA_CUT2;    
}

void EntryDuoFilaAusschuss()
{
    Stepper_2_Stop();
    Set_Servo_Bad_Fil();
    Stepper_1_SetPara(TRAVELSPEED+100, TRAVELACC+300);
    Stepper_3_SetPara(TRAVELSPEED+100, TRAVELACC+300);
    Stepper_3_Run('V', 300);
    Stepper_1_Run('V', 300);
              
    DisplaySendeBefehl(0x01);
    gotoxy(1,1);
    DisplaySendeString("Schlechtes Filament ");
    gotoxy(1,3);
    DisplaySendeString("                    ");
    gotoxy(1,2);
    DisplaySendeString("Wird aussortiert... ");
    gotoxy(1,4);
    DisplaySendeString("             Abbruch");  
    
    StatusDUO=DUO_FILA_AUSSCHUSS;    
}
void EntryFilaCut31()
{
    /*********************************
    
            CUT PROZESS 
    
    **********************************/
    DisplaySendeBefehl(0x01);
    gotoxy(1,1);
    DisplaySendeString("Filament wird  ge-");
    gotoxy(1,3);
    DisplaySendeString("schnitten");
    
    Stepper_1_Stop();
    Stepper_3_Leerlauf();

    Stepper_3_SetPara(100, 100);
    Stepper_1_SetPara(100, 100);
 
    Set_Cutter(550, 0, 1);
    motors2[0]->move(StepperMotor::FWD, 128*400*4);
    motors[0]->move(StepperMotor::BWD, 128*400*0.3);
    Set_Cutter(650, 0, 1);
    
    DisplaySendeBefehl(0x01);
    gotoxy(1,1);
    DisplaySendeString("Filament wird  ge-");
    gotoxy(1,3);
    DisplaySendeString("schnitten");
    
    motors2[0]->wait_while_active();
    motors[0]->move(StepperMotor::FWD, 128*400*0.3);
    motors[0]->wait_while_active();
    Stepper_3_Leerlauf();
   // wait(10);
    Set_Servo_Good_Fil();
    Stepper_1_SetHome();
    Stepper_1_Run('V', 300);
   
    
    DisplaySendeBefehl(0x01);
    gotoxy(1,1);
    DisplaySendeString("Filament ist gut.   ");
    gotoxy(1,3);
    DisplaySendeString("Wird gefoerdert...  ");
    gotoxy(1,4);
    DisplaySendeString("             Abbruch"); 
    
    StatusDUO=DUO_FILA_CUT3_1;
}

void EntryDuoFilaCut32()
{
    Stepper_1_SetHome();
    
    DisplaySendeBefehl(0x01);
    gotoxy(1,1);
    DisplaySendeString("Schlechtes Filament ");
    gotoxy(1,3);
    DisplaySendeString("erkannt.            ");
    gotoxy(1,2);
    DisplaySendeString("Zu erst Spleissen.  ");
    gotoxy(1,4);
    DisplaySendeString("             Abbruch");
    
    StatusDUO=DUO_FILA_CUT3_2;
}

void EntryDuoSpleissenVorbeGood()
{
    Stepper_1_SetPara(PRECISIONSPEED, PRECISIONACC);
    Stepper_1_Run('V', 40);
    
    StatusDUO = DUO_SPLEISSEN_VORBE_GOOD;
}

void EntryDuoSpleissenGood()
{
    Stepper_1_Stop();
    
    DisplaySendeBefehl(0x01);
    DisplaySendeBefehl(0x0C);
    gotoxy(1, 1);
    DisplaySendeString("ACHTUNG:");
    gotoxy(1, 2);
    DisplaySendeString("SPLEISSUNG!!!");
   
    
   // Stepper_1_SetPara(PRECISIONSPEED, PRECISIONACC);
   // Stepper_1_Move('V', 0.11*400);
    
    Stepper_1_SetPara(PRECISIONSPEED, PRECISIONACC);
    Stepper_2_SetPara(PRECISIONSPEED, PRECISIONACC);
    
    motors[0]->move(StepperMotor::BWD, 128*400*0.22);
    motors[1]->move(StepperMotor::BWD, 128*400*0.23);

    Set_Spleisser(ARConTIME, ARCoffTIME, REPETITONS);
    
    motors[0]->wait_while_active();
    motors[1]->wait_while_active();
    
    motors[0]->move(StepperMotor::FWD, 128*400*0.10);
    motors[1]->move(StepperMotor::FWD, 128*400*0.11);
    
    Set_Spleisser(ARConTIME, ARCoffTIME, REPETITONS+2);
    
    motors[0]->wait_while_active();
    motors[1]->wait_while_active();
    
    
    Stepper_1_SetPara(FILSPEED, FILACC);
    Stepper_2_SetPara(FILSPEED, FILACC);

    motors[0]->move(StepperMotor::BWD, 0.65*400*128);
    Thread::wait(10);
    Stepper_2_Move('R', 0.85*400);
    
    DisplaySendeBefehl(0x01);
    DisplaySendeBefehl(0x0C);
    gotoxy(1, 1);
    DisplaySendeString("Filament wird");
    gotoxy(1, 2);
    DisplaySendeString("abgekuehlt");

    Thread::wait(COOLINGTIME*1000);
    
    Stepper_1_SetPara(TRAVELSPEED+200, SLOWACC);
    Stepper_2_SetPara(TRAVELSPEED+200, SLOWACC);
    
    motors[0]->move(StepperMotor::FWD, 128*400*1.5);
    motors[1]->move(StepperMotor::FWD, 128*400*1.5);
    motors[0]->wait_while_active();
    motors[1]->wait_while_active();
     
    StatusDUO = DUO_SPLEISSEN_GOOD;
}

void EntryDuoSpleissenVorbeBad()
{
    Stepper_1_SetPara(PRECISIONSPEED, PRECISIONACC);
    Stepper_1_Run('V', 40);
    
    StatusDUO = DUO_SPLEISSEN_VORBE_BAD;
}

void EntryDuoSpleissenBad()
{
    Stepper_1_Stop();
    
    DisplaySendeBefehl(0x01);
    DisplaySendeBefehl(0x0C);
    gotoxy(1, 1);
    DisplaySendeString("ACHTUNG:");
    gotoxy(1, 2);
    DisplaySendeString("SPLEISSUNG!!!");
    
    
   // Stepper_1_SetPara(PRECISIONSPEED, PRECISIONACC);
   // Stepper_1_Move('V', 0.11*400);
    
       Stepper_1_SetPara(PRECISIONSPEED, PRECISIONACC);
    Stepper_2_SetPara(PRECISIONSPEED, PRECISIONACC);
    
    motors[0]->move(StepperMotor::BWD, 128*400*0.22);
    motors[1]->move(StepperMotor::BWD, 128*400*0.23);

    Set_Spleisser(ARConTIME, ARCoffTIME, REPETITONS);
    
    motors[0]->wait_while_active();
    motors[1]->wait_while_active();
    
    motors[0]->move(StepperMotor::FWD, 128*400*0.10);
    motors[1]->move(StepperMotor::FWD, 128*400*0.11);
    
    Set_Spleisser(ARConTIME, ARCoffTIME, REPETITONS+2);
    
    motors[0]->wait_while_active();
    motors[1]->wait_while_active();
    
    
    Stepper_1_SetPara(FILSPEED, FILACC);
    Stepper_2_SetPara(FILSPEED, FILACC);

    motors[0]->move(StepperMotor::BWD, 0.65*400*128);
    Thread::wait(10);
    Stepper_2_Move('R', 0.85*400);
    
    DisplaySendeBefehl(0x01);
    DisplaySendeBefehl(0x0C);
    gotoxy(1, 1);
    DisplaySendeString("Filament wird");
    gotoxy(1, 2);
    DisplaySendeString("abgekuehlt");

    Thread::wait(COOLINGTIME*1000);
    
    Stepper_1_SetPara(TRAVELSPEED+200, SLOWACC);
    Stepper_2_SetPara(TRAVELSPEED+200, SLOWACC);
    
    motors[0]->move(StepperMotor::FWD, 128*400*1.5);
    motors[1]->move(StepperMotor::FWD, 128*400*1.5);
    motors[0]->wait_while_active();
    motors[1]->wait_while_active();
        
    StatusDUO = DUO_SPLEISSEN_BAD;
}

void EntryDuoSpleissenVorbeBad2()
{
    Stepper_1_SetHome();
    
    DisplaySendeBefehl(0x01);
    gotoxy(1,1);
    DisplaySendeString("Schlechtes Filament ");
    gotoxy(1,3);
    DisplaySendeString("erkannt.            ");
    gotoxy(1,2);
    DisplaySendeString("Zu erst Spleissen.  ");
    gotoxy(1,4);
    DisplaySendeString("             Abbruch");
    
    StatusDUO = DUO_SPLEISSEN_VORBE_BAD;
}

void EntryDuoBad2()
{
    Stepper_1_SetPara(100, 100);
    Stepper_2_Leerlauf();
    Stepper_1_GoHome();
    Stepper_1_Stop();
    Stepper_2_Stop();
    
    /*********************************
    
            CUT PROZESS 
    
    **********************************/
    DisplaySendeBefehl(0x01);
    gotoxy(1,1);
    DisplaySendeString("Filament wird  ge-");
    gotoxy(1,3);
    DisplaySendeString("schnitten");
    
    Stepper_2_SetPara(100, 100);
    Stepper_1_SetPara(100, 100);
 
    Set_Cutter(550, 0, 1);
    motors[1]->move(StepperMotor::FWD, 128*400*4);
    motors[0]->move(StepperMotor::BWD, 128*400*0.3);
    Set_Cutter(650, 0, 1);
    
    DisplaySendeBefehl(0x01);
    gotoxy(1,1);
    DisplaySendeString("Filament wird  ge-");
    gotoxy(1,3);
    DisplaySendeString("schnitten");
    
    motors[1]->wait_while_active();
    motors[0]->move(StepperMotor::FWD, 128*400*0.3);
    motors[0]->wait_while_active();
    
    // wait(10);
    Set_Servo_Good_Fil();
    Stepper_1_SetHome();
    Stepper_2_SetPara(400, 300);
   // motors[1]->move(StepperMotor::FWD, 128*400*);
   // motors[1]->wait_while_active();
    Stepper_2_Run('V', 150);
       
    StatusDUO = DUO_FILA_BAD2;
}

void EntryDuoFilaCut22()
{
    StatusDUO = DUO_FILA_CUT2;
}

void EntryDuoFertigBad()
{
    Stepper_1_Stop();
    
    Stepper_1_SetPara(40, 100);
    Stepper_2_SetPara(300, 300);
    motors[0]->move(StepperMotor::FWD, 128*400*0.1);
    motors[0]->wait_while_active();
    motors[1]->move(StepperMotor::FWD, 128*400*2);
    motors[1]->wait_while_active();
    
    
    DisplaySendeBefehl(0x01);
    gotoxy(1,1);
    DisplaySendeString("Filament ist fertig.");
    gotoxy(1,2);
    DisplaySendeString("Bitte Messmodul ent-");
    gotoxy(1,4);
    DisplaySendeString("fernen fuer Auswurf ");
    
    while(InputKontrollmodul == 1){}
    
    DisplaySendeBefehl(0x01);
    gotoxy(1,1);
    DisplaySendeString("ACHTUNG!");
    gotoxy(1,3);
    DisplaySendeString("Nur Auswurf druecken");
    gotoxy(1,2);
    DisplaySendeString("ohne Messmodul!     ");
    gotoxy(1,4);
    DisplaySendeString("             Auswurf");
    
    while(ButtonABBRUCH==false)
    {
        ButtonABBRUCH = get_Button_2();
    }
    
    DisplaySendeBefehl(0x01);
    gotoxy(1,1);
    DisplaySendeString("Filament wegziehen, ");
    gotoxy(1,3);
    DisplaySendeString("wenn Schrittmotoren ");
    gotoxy(1,2);
    DisplaySendeString("nicht mehr greiffen.");
    
    Stepper_1_SetPara(300, 300);
    Stepper_2_SetPara(300, 300);
    motors[1]->move(StepperMotor::FWD, 128*400*2);
    motors[1]->wait_while_active();
    
    Stepper_1_Run('R', 300); 
    
    while(LS_1 == 0){}
    
    Stepper_2_Leerlauf();
    
    StatusDUO = DUO_FERTIG_BAD;
    
}

void EntryDuoFertigGood()
{
    Stepper_1_Stop();
    Stepper_1_SetPara(300, 300);
    Stepper_2_SetPara(300, 300);
    Stepper_2_Leerlauf();
    Stepper_2_Run('V', 300);
    Stepper_1_Run('V', 300);
    while(LS_1 == 0)
    {
         
    }
    Stepper_2_Leerlauf();
    Stepper_1_Stop();
    Stepper_1_SetPara(40, 100);
    
    motors[0]->move(StepperMotor::FWD, 128*400*0.1);
    
    DisplaySendeBefehl(0x01);
    gotoxy(1,1);
    DisplaySendeString("Filament ist fertig.");
    gotoxy(1,2);
    DisplaySendeString("Bitte Messmodul ent-");
    gotoxy(1,4);
    DisplaySendeString("fernen fuer Auswurf ");

    while(InputKontrollmodul == 1){}
    
    DisplaySendeBefehl(0x01);
    gotoxy(1,1);
    DisplaySendeString("ACHTUNG!");
    gotoxy(1,3);
    DisplaySendeString("Nur Auswurf druecken");
    gotoxy(1,2);
    DisplaySendeString("ohne Messmodul!     ");
    gotoxy(1,4);
    DisplaySendeString("             Auswurf");
    
    while(ButtonABBRUCH==false)
    {
        ButtonABBRUCH = get_Button_2();
    }
    
    DisplaySendeBefehl(0x01);
    gotoxy(1,1);
    DisplaySendeString("Filament wegziehen, ");
    gotoxy(1,3);
    DisplaySendeString("wenn Schrittmotoren ");
    gotoxy(1,2);
    DisplaySendeString("nicht mehr greiffen.");
    
    Stepper_1_SetPara(300, 300);
    
    Stepper_1_Run('R', 300); 
    
    while(LS_1 == 0){}
    
    
    StatusDUO = DUO_FERTIG_GOOD;    
}

void EntryDUO()
{
    ButtonSTART = get_Button_1();
    ButtonABBRUCH = get_Button_2();
    Fila_Good = get_InputKontrollmodul();
    Fertig = get_FertigSignal();
    
    switch(StatusDUO)
    {     
       case DUO_DEFAULT:
      
       EntryDuoStart();      
       break;
       
       case DUO_START:
        printf("MODUS DUO\n\r");
       if(ButtonSTART==true)
        {
            ButtonSTART=false;   
            EntryDuoEinlegen();     
        }
        else if(ButtonABBRUCH == true)
        {
            ButtonABBRUCH=false;
            DuoWechselFilament();
        }
        
       break;
       
       case DUO_EINLEGEN:
       if(Fila_Good == true)        //für Test->==false wenn gedrückt(heisst Filament ist gut)
        {
            EntryDuoFilaCut1();     
        }
        
       else if(ButtonABBRUCH == true)
        {    
            ButtonABBRUCH=false;
            EntryDuoDefault();
        }
        
       break;
       
       case DUO_FILA_CUT1:
       if(Fila_Good == false)        //für Test->==true wenn nicht gedrückt(heisst Filament ist schlecht) 
        {
            EntryDuoFilaBad1();
        }
       else if(LS_3 == 0)
        {
           // EntryDuoDefault();// nur für test
            EntryDuoFilaGood2();  
        }
       else if(ButtonABBRUCH == true)
        {
            ButtonABBRUCH=false;
            EntryDuoDefault();        
        }
       break;
       
       case DUO_FILA_BAD1:
       if(Fila_Good == true)       //für Test->==false wenn gedrückt(heisst Filament ist gut)
        {
            EntryDuoFilaCut1();
        }
       else if(ButtonABBRUCH == true)
        {
            ButtonABBRUCH=false;
            EntryDuoDefault();
        }
     
       break;
       
       case DUO_FILA_GOOD2:
        Stepper1CurrentPos = Stepper_1_GetPosition();
        Stepper1MarkPos = Stepper_1_GetMark();
        if(Stepper1CurrentPos > ((Stepper1MarkPos+(128*400*LAENGE_LS3_To_STEPPER2))-100))
        {
            EntryDuoFilaGood3();
        }
        else if(Fila_Good == false)  //für Test->==true wenn nicht gedrückt(heisst Filament ist schlecht)
        {
            EntryDuoFilaBad1();
        }
        else if(ButtonABBRUCH == true)
        {
            ButtonABBRUCH=false;
            EntryDuoDefault();
        } 
       break;
       
       case DUO_FILA_GOOD3:
       if(Fila_Good == false)  //für Test->==true wenn nicht gedrückt(heisst Filament ist schlecht)
        {
            EntryDuoFilaCut2();
        }
        else if(ButtonABBRUCH == true)
        {
            ButtonABBRUCH=false;
            EntryDuoDefault();
        }
       break; 
       
       case DUO_FILA_CUT2:
       if((LS_3 == 1) && (LS_2 == 1))
        {
               EntryDuoFilaAusschuss();
        }
        else if(ButtonABBRUCH == true)
        {
            ButtonABBRUCH=false;
            EntryDuoDefault();
        }
       break;
       
       case DUO_FILA_AUSSCHUSS:
       if(LS_1 == 1)
        {
            EntryDuoFertigBad();
        }
       
        else if(Fila_Good == true)        //für Test->==false wenn gedrückt(heisst Filament ist gut)
        {
            EntryFilaCut31();     
        }
        else if(ButtonABBRUCH == true)
        {
            ButtonABBRUCH=false;
            EntryDuoDefault();
        }
       break;
       
       case DUO_FILA_CUT3_1:
       if((Fila_Good == false)&&(Fertig == true)) //für Test->==true wenn nicht gedrückt(heisst Filament ist schlecht)
        {
            EntryDuoFertigGood();
        }
        else if(Fila_Good == false)  //für Test->==true wenn nicht gedrückt(heisst Filament ist schlecht)
        {
            EntryDuoFilaCut32();
        }
        else if(LS_2 == 0)
        {
            EntryDuoSpleissenVorbeGood();
        }
        else if(ButtonABBRUCH == true)
        {
            ButtonABBRUCH=false;
            EntryDuoDefault();
        }
        
       break;
       
       case DUO_FILA_CUT3_2:
       if(Fertig == true)
        {
            EntryDuoFertigGood();
        }
        else if(LS_2 == 0)
        {
            EntryDuoSpleissenVorbeBad();
        }
       else if(ButtonABBRUCH == true)
        {
            ButtonABBRUCH=false;
            EntryDuoDefault();
        }
       break;
       
       case DUO_SPLEISSEN_VORBE_BAD:
       if(Fertig == true)
        {
            EntryDuoFertigGood();
        }
        else if(LS_3 == 0)
        {
            EntryDuoSpleissenBad();
        }
        else if(ButtonABBRUCH == true)
        {
            ButtonABBRUCH=false;
            EntryDuoDefault();
        }
       break;
       
       case DUO_SPLEISSEN_BAD:
       
        EntryDuoBad2();
       break;
       
       case DUO_SPLEISSEN_VORBE_GOOD:
       if(Fertig == true)
        {
            EntryDuoFertigGood();
        }
        else if(Fila_Good == false)  //für Test->==true wenn gedrückt(heisst Filament ist schlecht)
        {
            EntryDuoSpleissenVorbeBad2();
        }
        else if(LS_3 == 0)
        {
            EntryDuoSpleissenGood();
        }
        else if(ButtonABBRUCH == true)
        {
            ButtonABBRUCH=false;
            EntryDuoDefault();
        }
       break;
       
       
       case DUO_SPLEISSEN_GOOD:
       
        EntryDuoFilaGood3();
       break;
       
       case DUO_FILA_BAD2:
        
        EntryDuoFilaCut22();
       break;
       
       case DUO_FERTIG_BAD:
        EntryDuoDefault();
       break;
       
       case DUO_FERTIG_GOOD:
        EntryDuoDefault();
       break;
             
    }   
}
