 /*
  ******************************************************************************
  * PES_4 Gruppe GRUEN
  * 
  * @author Scherrer Fabian
  * @author Hagen Raphael
  *
  * INFO:
  *
  * Setup File für Spleiss_Modul
  * 
  * Folgende GPIOS nicht verwenden: PA11, PA12, PA5, PA8, PA9, PC13
  *
  * Freie GPIOS: 
  *                 PB_10    PWM
  *                 PB_8     PWM/I2C1_SCL
  *                 PB_9     PWM/I2C1_SDA
  *                 PC_4     ADC
  *                 PC_9     PWM
  *                 PB_15
  *                 PB_14
  *                 PB_13
  *
  ******************************************************************************
  */

#ifndef MBED_SETUP_H
#define MBED_SETUP_H


// -----------------------------------------------------------------------------
#include "mbed.h"
#include "rtos.h"
#include "main.h"
#include "ST_SOLO.h"
#include "ST_DUO.h"
#include "STEPPER_INIT.h"
#include "DevSPI.h"
#include "XNucleoIHM02A1.h"
#include "Display.h"
#include "PWM2.h"
// -----------------------------------------------------------------------------
// GPIO
// -----------------------------------------------------------------------------

    // Stepper_Treiber
    #define SPI_CS_1        PA_4
    #define SPI_CS_2        PA_10
    #define SPI_CLK         PB_3
    #define SPI_MISO        PA_6
    #define SPI_MOSI        PA_7
    #define STB_MOTOR       PB_5
    #define IRQ_FLAG_MOTOR  PC_1
    #define IRQ_BUSY_MOTOR  PC_0
    
    // Display
    #define DISP_RS         PC_3
    #define DISP_RW         PC_2
    #define DISP_E          PB_7
    #define DISP_B0         PA_15
    #define DISP_B1         PA_14
    #define DISP_B2         PA_13
    #define DISP_B3         PC_12
    #define DISP_B4         PC_10
    #define DISP_B5         PC_8
    #define DISP_B6         PC_6
    #define DISP_B7         PC_5

    // Cutter_Einheit
    #define CUTTER_ARC      PB_6
    #define SERVO           PB_4

    // Speiss_Einheit
    #define SPLEISSER_ARC_1 PC_7
    #define SPLEISSER_ARC_2 PB_0
    
    // Lichtschranken
    #define LICHTSCHRANKE_1 PA_0
    #define LICHTSCHRANKE_2 PB_1
    #define LICHTSCHRANKE_3 PA_1
    
    // Buttons
    #define START_BUTTON    PA_2
    #define STOP_BUTTON     PA_3

    // Kommunikation_Filamentmessung
    #define CUT_SIGNAL      PB_2
    #define COM_SIGNAL      PB_12
    // PC11 Reserve!!!!


// -----------------------------------------------------------------------------
// Parameter
// -----------------------------------------------------------------------------

    // Weiche
    #define SERVO_FR        240  // [Hz]
    #define GOOD_FIL        60.5 // [°] (max 90)
    #define BAD_FIL         0    // [°] (min 0)
    
    // Cutter
    #define FREQ_CUTTER     20000 // [Hz]
    #define DUTY_CUTTER     70    // [%]

    // Spleisser
    #define FREQ_SP_1       20000 // [Hz]
    #define FREQ_SP_2       17000 // [Hz]
    #define DUTY_SP         70    // [%]
    


#endif
