/**
 ******************************************************************************
 * @file    main.cpp
 * @author  Davide Aliprandi, STMicroelectronics
 * @version V1.0.0
 * @date    November 4th, 2015
 * @brief   mbed test application for the STMicroelectronics X-NUCLEO-IHM02A1
 *          Motor Control Expansion Board: control of 2 motors.
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; COPYRIGHT(c) 2015 STMicroelectronics</center></h2>
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *   1. Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 *   3. Neither the name of STMicroelectronics nor the names of its contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ******************************************************************************
 */


/* Includes ------------------------------------------------------------------*/

/* mbed specific header files. */
#include "mbed.h"
#include "main.h"
#include "PWM.h"

/* Helper header files. */
#include "DevSPI.h"

/* Expansion Board specific header files. */
#include "XNucleoIHM02A1.h"


/* Definitions ---------------------------------------------------------------*/

/* Number of movements per revolution. */
#define MPR_1 4

/* Number of steps. */
#define STEPS_1 (400 * 128)   /* 1 revolution given a 400 steps motor configured at 1/128 microstep mode. */
#define STEPS_2 (STEPS_1 * 2)

/* Delay in milliseconds. */
#define DELAY_1 1000
#define DELAY_2 2000
#define DELAY_3 5000

DigitalOut led1(LED1);



InterruptIn button1(USER_BUTTON);
volatile int idx = 0;
volatile bool button1_pressed = false; // Used in the main loop
volatile bool button1_enabled = true; // Used for debouncing
Timeout button1_timeout; // Used for debouncing

// Enables button when bouncing is over
void button1_enabled_cb(void)
{
    button1_enabled = true;
}

// ISR handling button pressed event
void button1_onpressed_cb(void)
{
    if (button1_enabled) { // Disabled while the button is bouncing
        button1_enabled = false;
        button1_pressed = true; // To be read by the main loop
        
        if(idx<4){
            idx++;
        }
        else{idx=1;}
            
        button1_timeout.attach(callback(button1_enabled_cb), 0.03); // Debounce time 300 ms
    }
}

/* Variables -----------------------------------------------------------------*/

/* Motor Control Expansion Board. */
XNucleoIHM02A1 *x_nucleo_ihm02a1_1;
//XNucleoIHM02A1 *x_nucleo_ihm02a1_2;
/* Initialization parameters of the motors connected to the expansion board. */
L6470_init_t init[L6470DAISYCHAINSIZE] = {
    /* First Motor. */
    {
        9.0,                           /* Motor supply voltage in V. */
        400,                           /* Min number of steps per revolution for the motor. */
        1.7,                           /* Max motor phase voltage in A. */
        3.06,                          /* Max motor phase voltage in V. */
        300.0,                         /* Motor initial speed [step/s]. */
        500.0,                         /* Motor acceleration [step/s^2] (comment for infinite acceleration mode). */
        500.0,                         /* Motor deceleration [step/s^2] (comment for infinite deceleration mode). */
        992.0,                         /* Motor maximum speed [step/s]. */
        0.0,                           /* Motor minimum speed [step/s]. */
        602.7,                         /* Motor full-step speed threshold [step/s]. */
        3.06,                          /* Holding kval [V]. */
        3.06,                          /* Constant speed kval [V]. */
        3.06,                          /* Acceleration starting kval [V]. */
        3.06,                          /* Deceleration starting kval [V]. */
        61.52,                         /* Intersect speed for bemf compensation curve slope changing [step/s]. */
        392.1569e-6,                   /* Start slope [s/step]. */
        643.1372e-6,                   /* Acceleration final slope [s/step]. */
        643.1372e-6,                   /* Deceleration final slope [s/step]. */
        0,                             /* Thermal compensation factor (range [0, 15]). */
        3.06 * 1000 * 1.10,            /* Ocd threshold [ma] (range [375 ma, 6000 ma]). */
        3.06 * 1000 * 1.00,            /* Stall threshold [ma] (range [31.25 ma, 4000 ma]). */
        StepperMotor::STEP_MODE_1_128, /* Step mode selection. */
        0xFF,                          /* Alarm conditions enable. */
        0x2E88                         /* Ic configuration. */
    },

    /* Second Motor. */
    {
        9.0,                           /* Motor supply voltage in V. */
        400,                           /* Min number of steps per revolution for the motor. */
        1.7,                           /* Max motor phase voltage in A. */
        3.06,                          /* Max motor phase voltage in V. */
        300.0,                         /* Motor initial speed [step/s]. */
        500.0,                         /* Motor acceleration [step/s^2] (comment for infinite acceleration mode). */
        500.0,                         /* Motor deceleration [step/s^2] (comment for infinite deceleration mode). */
        992.0,                         /* Motor maximum speed [step/s]. */
        0.0,                           /* Motor minimum speed [step/s]. */
        602.7,                         /* Motor full-step speed threshold [step/s]. */
        3.06,                          /* Holding kval [V]. */
        3.06,                          /* Constant speed kval [V]. */
        3.06,                          /* Acceleration starting kval [V]. */
        3.06,                          /* Deceleration starting kval [V]. */
        61.52,                         /* Intersect speed for bemf compensation curve slope changing [step/s]. */
        392.1569e-6,                   /* Start slope [s/step]. */
        643.1372e-6,                   /* Acceleration final slope [s/step]. */
        643.1372e-6,                   /* Deceleration final slope [s/step]. */
        0,                             /* Thermal compensation factor (range [0, 15]). */
        3.06 * 1000 * 1.10,            /* Ocd threshold [ma] (range [375 ma, 6000 ma]). */
        3.06 * 1000 * 1.00,            /* Stall threshold [ma] (range [31.25 ma, 4000 ma]). */
        StepperMotor::STEP_MODE_1_128, /* Step mode selection. */
        0xFF,                          /* Alarm conditions enable. */
        0x2E88                         /* Ic configuration. */
    }
};


/* Main ----------------------------------------------------------------------*/

int main()
{
    /*----- Initialization. -----*/

    /* Initializing SPI bus. */
#ifdef TARGET_STM32F429
    DevSPI dev_spi(D11, D12, D13);
#else
    DevSPI dev_spi(D11, D12, D3);
#endif

    /* Initializing Motor Control Expansion Board. */
    x_nucleo_ihm02a1_1 = new XNucleoIHM02A1(&init[0], &init[1], A4, A5, D4, A2, &dev_spi);
   // x_nucleo_ihm02a1_2 = new XNucleoIHM02A1(&init[0], &init[1], A4, A5, D4, A2, &dev_spi);

    /* Building a list of motor control components. */
    L6470 **motors = x_nucleo_ihm02a1_1->get_components();
    //L6470 **motors2 = x_nucleo_ihm02a1_2->get_components();
    /*----- Setting home and marke positions, getting positions, and going to positions. -----*/

    /* Setting the home position. */
    //motors[0]->set_home();

   

    /*----- Running together for a certain amount of time. -----*/
    
    button1.fall(callback(button1_onpressed_cb)); // Attach ISR to handle button press event

 while(1) {
        if (button1_pressed) { // Set when button is pressed
            button1_pressed = false;   
            switch (idx){
                case 1: 
                            pwm_io(50, 0.0); // 20ms - 0%
                         /* Printing to the console. */
                         printf("--> Running together for %d seconds.\r\n", DELAY_3 / 1000);
                                    
                            motors[1]->prepare_set_acceleration(7000);
                            motors[0]->prepare_set_acceleration(7000);
                        
                        

                         /* Preparing each motor to perform a run at a specified speed. */
                        
                            motors[1]->prepare_run(StepperMotor::BWD, 800);
                            motors[0]->prepare_run(StepperMotor::BWD, 808);  

                            /* Performing the action on each motor at the same time. */
                            x_nucleo_ihm02a1_1->perform_prepared_actions();   
                
                break;
                case 2: 
                             /* Printing to the console. */
                                printf("--> Hard Stop.\r\n");

                                /* Preparing each motor to perform a hard stop. */
                                for (int m = 0; m < L6470DAISYCHAINSIZE; m++) {
                                    motors[m]->prepare_hard_stop();
                                }
                            
                                /* Performing the action on each motor at the same time. */
                                x_nucleo_ihm02a1_1->perform_prepared_actions();
                break;
                case 3:
                      //   while (!button1_pressed) { // Set when button is pressed
                                    // button1_pressed = false;
                                    for (int m = 0; m < L6470DAISYCHAINSIZE; m++) {
                                            motors[m]->prepare_set_acceleration(300);
                                            //motors[m]->prepare_set_speed(1);
                                            }
                                     x_nucleo_ihm02a1_1->perform_prepared_actions();
                                     for (int m = 0; m < L6470DAISYCHAINSIZE; m++) {
                                           // motors[m]->prepare_set_acceleration(7000);
                                            motors[m]->prepare_set_speed(100);
                                            }
                                     x_nucleo_ihm02a1_1->perform_prepared_actions();
                                  /*   motors[1]->move(StepperMotor::FWD, 400*128); 
                                     motors[0]->move(StepperMotor::FWD, 400*128);
                                     motors[1]->wait_while_active();
                                     motors[0]->wait_while_active();
                                     motors[1]->move(StepperMotor::BWD, 400*128);
                                     motors[0]->move(StepperMotor::BWD, 400*128);
                                     motors[1]->wait_while_active();
                                     motors[0]->wait_while_active();
                                     */
                                     //while (idx==3){
                                     pwm_io(40, 0.85); // 20ms - 25%  
                                     wait(0.5);
                                     motors[1]->run(StepperMotor::BWD,100);
                                     motors[0]->run(StepperMotor::BWD,101);
                                  //  }
                                                        
                            /* Waiting. */
                          //  wait_ms(DELAY_2);
                
                break;
                case 4:
                
                        /* Preparing each motor to set High Impedance State. */
                        for (int m = 0; m < L6470DAISYCHAINSIZE; m++) {
                            motors[m]->prepare_hard_hiz();
                        }
                    
                        /* Performing the action on each motor at the same time. */
                        x_nucleo_ihm02a1_1->perform_prepared_actions();
                        float zusatz= 0.1;
                       // for(int i = 0;i>10;i++){
                           //zusatz=zusatz-0.005;
                           
                            
                            pwm_io2(20000, 0.075); // 20ms - 25%   
                            wait(1);
                            pwm_io2(20000, zusatz); // 20ms - 25%
                            
                     // }
                break;
                
            }
          //  printf("Button pressed %d\n", idx++);
           // led1 = !led1;
        }
    }
    
}
