#include "mbed.h"
#include "mbed_events.h"
#include "MPU9250.h"

#define SAMPLE_TIME 100

DigitalOut led1(LED1);
InterruptIn sw(USER_BUTTON);

Thread eventthread;
Thread imuthread;
bool read_imu_isrunning;


// Pin defines
DigitalOut led_green(D4);

//-----------------------------------------------------
//IMU
//-----------------------------------------------------

void rise_handler(void)
{
    printf("rise_handler in context %p\r\n", Thread::gettid());
    // Toggle LED
    led1 = !led1;
    for (int i = 0; i<10; i++) {
        led_green = !led_green;
        wait(0.5);
    }
}

void fall_handler(void)
{
    printf("fall_handler in context %p\r\n", Thread::gettid());
    // Toggle LED
    led1 = !led1;
}






int main()
{
    //pc.baud(9600);
    //imuSetup();
    //imuthread.start(readIMU);

    // Request the shared queue
    EventQueue *queue = mbed_event_queue();
    //printf("Starting in context %p\r\n", Thread::gettid());

    // The 'rise' handler will execute in IRQ context
    sw.rise(queue->event(rise_handler));
    // The 'fall' handler will execute in the context of the shared queue (actually the main thread)
    sw.fall(queue->event(fall_handler));
    // Setup complete, so we now dispatch the shared queue from main
    queue->dispatch_forever();
}