#include "mbed.h"

#define WS2801_RGB 0


class Adafruit_WS2801
{

public:

    // Configurable pins:
    Adafruit_WS2801(int16_t n, PinName dpin, PinName cpin, uint8_t order=WS2801_RGB);

    // Release memory (as needed):
    ~Adafruit_WS2801();

    void begin(void);
    void show(void);
    void setPixelColor(uint16_t n, uint32_t c);

    int zufallige_Zahl(void);
    int show_Bereich(int, int);
    int show_Aktuell(int, int);
    
    int Wasserwaage(float,int);

    uint32_t getPixelColor(uint16_t n);

private:

    uint16_t
    numLEDs;
    
    uint8_t
    *pixels,   // Holds color values for each LED (3 bytes each)
    rgb_order // Color order; RGB vs GRB (or others, if needed in future)
    ;
    DigitalOut  clkpin;
    DigitalOut  datapin;     // Clock & data pin numbers
    void    alloc(uint16_t n);
//    startSPI(void);
    bool hardwareSPI; // If 'true', using hardware SPI
    bool  begun;       // If 'true', begin() method was previously invoked
    
    int aktuelle_Zeit;
    
};

