//
//  Creator: Gasser Michael, Mayer Marco, Portmann Rafaela
//  Date: 20.03.2020
//
//
//******************************************************************************
//******************************************************************************





//******************************************************************************
//
//  Includes
//
//******************************************************************************

#include "mbed.h"
#include "Adafruit_WS2801.h"
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "Definitionen.h"

//******************************************************************************
//
//  Aus Adafruit Libary
//  Copyright @Adafruit
//
//******************************************************************************

SPI spi(SPI_MOSI, SPI_MISO, SPI_SCK); // mosi, miso, sclk


// Constructor for use with arbitrary clock/data pins:
Adafruit_WS2801::Adafruit_WS2801(int16_t n, PinName dpin, PinName cpin, uint8_t order) 
    : clkpin(cpin), datapin(dpin)
{
    rgb_order = order;
    alloc(n);
    hardwareSPI = false;
}


// Allocate 3 bytes per pixel, init to RGB 'off' state:
void Adafruit_WS2801::alloc(uint16_t n)
{
    begun   = false;
    numLEDs = ((pixels = (uint8_t *)calloc(n, 3)) != NULL) ? n : 0;
    hardwareSPI = true;
}


// Release memory (as needed):
Adafruit_WS2801::~Adafruit_WS2801(void)
{
    if (pixels != NULL) {
        free(pixels);
    }
}

// Activate hard/soft SPI as appropriate:
void Adafruit_WS2801::begin(void)
{
    // Setup the spi for 8 bit data, high steady state clock,
    // second edge capture, with a 1MHz clock rate
    spi.format(8,0);
    spi.frequency(1000000);
    begun = true;
}


void Adafruit_WS2801::show(void)
{
    uint16_t i, nl3 = numLEDs * 3; // 3 bytes per LED

    if( hardwareSPI ) {
        for(i=0; i<nl3; i++ ) {
            spi.write( pixels[i]);
        }        
        wait_ms(1); // Needed otherwise sometimes doesnt display
    } else {
        uint8_t  bit;

        // Write 24 bits per pixel:
        for(i=0; i<nl3; i++ ) {
            for(bit=0x80; bit; bit >>= 1) {
                clkpin = 0;
                datapin = (pixels[i] & bit) ? 1 : 0;
                clkpin = 1;
                wait_us(100);
            }
        }
        datapin = 0;

        clkpin = 0;
        wait_ms(1); // Data is latched by holding clock pin low for 1 millisecond
        clkpin = 1;
    }
}

// Set pixel color from 'packed' 32-bit RGB value:
void Adafruit_WS2801::setPixelColor(uint16_t n, uint32_t c)
{
    if( n < numLEDs) { // Arrays are 0-indexed, thus NOT '<='
        
        uint8_t *p = &pixels[n * 3];
        
        *p++ = c >> 16;  // Red
        *p++ = c >>  8;  // Green
        *p++ = c;        // Blue
    }
}



// Query color from previously-set pixel (returns packed 32-bit RGB value)
uint32_t Adafruit_WS2801::getPixelColor(uint16_t n)
{
    if(n < numLEDs) {
        uint16_t ofs = n * 3;
        return (rgb_order == WS2801_RGB) ?
               ((uint32_t)pixels[ofs] << 16) | ((uint16_t) pixels[ofs + 1] <<  8) | pixels[ofs + 2] :
               (pixels[ofs] <<  8) | ((uint32_t)pixels[ofs + 1] << 16) | pixels[ofs + 2];
    }

    return 0; // Pixel # is out of bounds
}



//******************************************************************************
//
//  Own functions PES 4
//
//******************************************************************************

// Show Sensor Position
int Adafruit_WS2801::show_Aktuell(int aktuell, int sensor)
{
    int neu;
    setPixelColor(sensor,RED); 
    
    if (sensor == aktuell){ 
        aktuelle_Zeit ++;
    }else{
        aktuelle_Zeit = 0;
        neu = show_Bereich(aktuell,sensor);
    }
    
    if (aktuelle_Zeit>=5){
        neu = show_Bereich(aktuell,sensor);       
    }
    
    return neu;
}

// Zeigt einen Bereich an
int Adafruit_WS2801::show_Bereich(int aktuell, int sensor)
{
    // Set old Value to Dark
    if (sensor != aktuell-1){setPixelColor(aktuell-1,BLACK); }
    if (sensor != aktuell+1){setPixelColor(aktuell+1,BLACK); }

    // Set new Value to Red
    int random = zufallige_Zahl();
    setPixelColor(random-1,GREEN); 
    setPixelColor(random+1,GREEN); 
    
    // Display Value      
    show();
    
    return random;
}


// Create a Randon Position for the barriers
int Adafruit_WS2801::zufallige_Zahl(void)
{
    const int x = 1;
    const int y = LED_NUM-2;
    int random;

    /* generates random numbers between X and Y  */
    srand (time(0));
    random = (rand () % ((y + 1) - x)) + x;
    
    return random;
}

// Übung Wasserwaage
int Adafruit_WS2801::Wasserwaage(float winkel, int led_alt)
{   
    bool negativ = false;
    float schrittweite = max_Winkel * 2 / (LED_NUM+1);
    float schrittweite_halb = schrittweite/2;
    int i, led_Aktuell;

    // Überprüfen ob Winkel negativ
    if (winkel < 0){negativ = true;}
    
    // Leztes leuchtendes LED zurück setzen
    setPixelColor(led_alt,BLACK);
       
    // Setzt den Winkel auf den Betrag des Winkels (immer Positiv)
    winkel = abs(winkel);    
    
    // Wenn der Winkel Grösser ist wie der Maximal definierte Winkel Leuchtet das lezte led Rot    
    if (winkel >= max_Winkel){
        led_Aktuell = (LED_NUM - 1) * negativ;
        setPixelColor(led_Aktuell, RED);
    }
    
    // 
    else {
         for(i = 0; i < (LED_NUM+1)/2; i++){
             
             // Wenn es das mittlere LED ist
             if(winkel >= 0 && winkel < schrittweite_halb){led_Aktuell = (LED_NUM-1)/2;}
             
             // Jedes andere LED
             else if(winkel >= (i-1) * schrittweite + schrittweite_halb && winkel < (i + 1) * schrittweite + schrittweite_halb){
                 if(!negativ){led_Aktuell = (LED_NUM-1) / 2 - i;}
                 else {led_Aktuell = (LED_NUM-1) / 2 + i;}
                 }
             }
             setPixelColor(led_Aktuell, GREEN);
        } 
        
    // Gibt die Position des Leuchtenden LED's zurück
    show();
    return led_Aktuell;     
}