#include "mbed.h"

#include "IRSensor.h"
#include "EncoderCounter.h"
#include "LowpassFilter.h"
#include "Controller.h"
#include "KontrastSensor.h"
#include "Drive.h"
#include "CheckWalls.h"
#include "Turn.h"

//Initialisierung LEDs Blinker/Surri/Button
DigitalIn button(USER_BUTTON);  //Moduswählknopf
DigitalOut myled(LED1);     //Heartbeat (evt auch Anzeige für Modus, vor start
DigitalOut blinker0(PA_4);  //Blinker links
DigitalOut blinker1(PC_1);  //Blinker rechts
DigitalOut surri(PC_0);     //

//Initialisierung LEDs Nightrider
PwmOut led0(PB_0);  //von links nach rechts
PwmOut led1(PB_8);
PwmOut led2(PB_3);
PwmOut led3(PB_5);
PwmOut led4(PB_4);
PwmOut led5(PB_10);
PwmOut led6(PB_9);

//Initialisierung IR-Sensoren
AnalogIn distance0(PC_2); //Kreieren der Eingangsobjekte
AnalogIn distance1(PC_3);
AnalogIn distance2(PC_5);
AnalogIn distance3(PB_1);
IRSensor irSensor0(distance0);    //rechts
IRSensor irSensor1(distance1);    //vorne
IRSensor irSensor2(distance2);    //links-vorne
IRSensor irSensor3(distance3);    //links-hinten

//Initialisierung Kontrastsensor
AnalogIn kontrast(PC_0);

//Initialisierung Motor und Encoder
DigitalOut enableMotorDriver(PB_2);
PwmOut pwmLeft(PA_8);   //Motor links
PwmOut pwmRight(PA_9);  //Motor rechts
EncoderCounter counterLeft(PB_6, PB_7); //Encoder für Motor links
EncoderCounter counterRight(PA_6, PC_7);//Encoder für Motor rechts

DigitalOut enable(PC_1);

Controller controller(pwmLeft, pwmRight, counterLeft, counterRight);

int state = 0;

int main()
{

    enableMotorDriver = 1; // Schaltet den Leistungstreiber ein
    enable = 1;

    int wallRight = 0;
    int wallFront = 0;
    int wallLeft = 0;
    int blackLine = 0;
    int dontStop = 0;
    //int way = 220;
    
//    int way[5][10][4] = {{0},{0},{0}}; // Abspeicherung wird in roboterkoordinaten gespeichert vierstellige Zahl => 1.Zahl gefahrene Richtung, 2.Zahl Wand rechts, 3.Zahl Wand vorne, 4.Zahl Wand links
    
    //Funktionsdeklarationen
    CheckWalls checkWalls(irSensor0, irSensor1, irSensor2, wallRight, wallFront, wallLeft); //Ermittlung wo freie Wege(0) bzw welche Waende vorhanden (1)
    Turn turn(counterLeft, counterRight, controller, wallRight, wallFront, wallLeft, dontStop);   //Nach Ausrichtung bewegt sich der Roboter um ein Feld weiter und die Ausrichutung beginnt von vorne
    KontrastSensor kontrastSensor(kontrast, blackLine);
    Drive drive(kontrastSensor, counterLeft, counterRight, controller, irSensor0, irSensor1, irSensor2, irSensor3, dontStop); //20cm nach vorne...//Ablauf ist jeweils immer Feldweise...Waende checken, allenfalls drehen (Ausrichten), waehrend der Fahrt nur Ausrichtung der Geradeausfahrt...


    while(1) { // Wiederholungsschleife


        switch(state) { //Wartemodus 1. Lauf
            case 0: {


                while (button) {
                    //printf("WARTE AUF 1.START...");
                    //controller.setDesiredSpeedRight(0.5f);
                    //controller.setDesiredSpeedLeft(-0.5f);
                    wait(1.0f);         //Die Ruhe vor dem Sturm...
                }

                state = 1;
                break;
            }
            case 1: {// 1.Lauf Fahrzyklus und Aufzeichungszyklus


                checkWalls.check(); //prueft wo Waende vorhanden sind

                turn.turning(); //entscheidet welche Richtung und Wendet dann zu dieser...


                //saveWay
                //Abspeicherung der Waende...
//                    if(wallRight == 1){
//                        way[0][0][1] = 1;
//                    } else {
//                        way[0][0][1] = 0;
//                    }
//
//                    if(wallRight == 1){
//                        way[0][0][2] = 1;
//                    } else{
//                        way[0][0][2] = 0;
//                    }
//
//                    if(wallRight == 1){
//                        way[0][0][3] = 1;
//                    } else{
//                        way[0][0][3] = 0;
//                    }
                //Abspeicherung des entschiedenen Wegs und Anpassung des
                //dontStop = way%10;
                //way = way/10;
            

                drive.driving(); //faehrt, kontrolliert ob richtig steht und achtet auch schwarze Linie am Boden

                if(blackLine == 1) { //ist schwarze Linie ueberfahren...stoppt der Fahrzyklus hier.

                    state = 2;
                }
                break;
            }
            case 2: { //Ziel erreicht und Wartemodus fuer 2. Lauf

                controller.setDesiredSpeedRight(0.0f);
                controller.setDesiredSpeedLeft(0.0f);

                while (button) {
                    //printf("WARTE AUF 2.START...");
                    wait(1.0f);
                }
                blackLine = 0;
                state = 3;
                break;
            }
            case 3: {//2. Lauf Fahrzyklus


                //pruefug der waender entfaellt, da jetzt die daten aus dem speicher geladen werden
                //checkWalls.check(); //prueft wo Waende vorhanden sind
                //
                //integer fuer kuerzesten weg...1 rechts 2 gerade aus 3 links
                // wallRight = 0;
                // wallFront = 0;
                // wallLeft = 0;

                turn.turning(); //entscheidet welche Richtung und Wendet dann zu dieser...

                //dontStop = 2;

                drive.driving(); //faehrt, kontrolliert ob richtig steht und achtet auch schwarze Linie am Boden

                if(blackLine == 1) { //ist schwarze Linie ueberfahren...stoppt der Fahrzyklus hier.

                    state = 4;
                }

                break;

            }
            case 4: { //Ziel erreicht und Wartemodus fuer 2. Lauf

                controller.setDesiredSpeedRight(0.0f);
                controller.setDesiredSpeedLeft(0.0f);

                while (button) {
                    //printf("SCHLUSS...");
                    wait(1.0f);
                }

                state = 5;
                break;
            }
            default: {
                state = 0;
                break;
            }
        }




        //printf("DistanzRechts = %.0f mm\n\r", irSensor0.read());
        //printf("DistanzVorne = %.0f mm\n\r", irSensor1.read());
        //printf("DistanzLinksVorne = %.0f mm\n\r", irSensor2.read());
        //printf("DistanzLinksHinten = %.0f mm\n\r", irSensor3.read());
        //printf("WandRechts = %d \n\r", wallRight);
        //printf("WandVorne = %d \n\r", wallFront);
        //printf("WandLinks = %d \n\r", wallLeft);


        // printf("CountsRight = %d\n", counterRight.read());
        // printf("CountsLeft = %d\n", counterLeft.read());
        //kontrastSensor.check();
        //printf("SchwarzeLinie  =  %d", blackLine);
        myled =! myled; // LED is ON Heartbeat
        wait(0.1f);

        


    }
}
