#ifndef DRIVE_H_
#define DRIVE_H_

#include <cstdlib>
#include <mbed.h>

#include "IRSensor.h"
#include "Controller.h"
#include "EncoderCounter.h"
#include "KontrastSensor.h"


class Drive
{

public:
    
    Drive(KontrastSensor& kontrastSensor, EncoderCounter& counterLeft, EncoderCounter& counterRight, Controller& controller, IRSensor& irSensor0, IRSensor& irSensor1, IRSensor& irSensor2, IRSensor& irSensor3, int& dontStop);
    virtual ~Drive();
    void driving();
private:

    static const float FRONTDISTANCE;
    static const float DRIVINGSPEED;
    static const int DRIVINGCOUNTS; 
    
    float difference;
    
    KontrastSensor& kontrastSensor;
    
    EncoderCounter& counterLeft;
    EncoderCounter& counterRight;
    
    Controller& controller;
    
    IRSensor& irSensor0;
    IRSensor& irSensor1;
    IRSensor& irSensor2;
    IRSensor& irSensor3;
    
    int& dontStop;
    


};

#endif /* DRIVE_H_ */