#include <cmath>
#include "IRSensor.h"

using namespace std;


IRSensor::IRSensor(AnalogIn& distance) :
    distance(distance)
{}

IRSensor::~IRSensor() {}

float IRSensor::read()
{
    double d = distance * 3.3f; // Change the value to be in the 0 to 3300 range
    float f = 14.098f*((d)*(d)*(d)*(d)*(d)*(d)) - 147.35f*((d)*(d)*(d)*(d)*(d)) + 627.68*((d)*(d)*(d)*(d)) - 1403.5f*((d)*(d)*(d)) + 1765.1f*((d)*(d)) - 1236.9f*(d) + 430.44f; // Lesen der Distanz in [mm]  
    
    return f;
}