#include <cmath>
#include "mbed.h"
#include "Drive.h"




using namespace std;

const float Drive::FRONTDISTANCE = 73.0f; //Abstand Sensor zur VorderWand //DONT TOUCH  //62.0f //55.0 110.0
const float Drive::DRIVINGSPEED = 130.0f;//Fahrgeschwindigkeit  Drehzahl in [rpm]       //130.0f
const int Drive::DRIVINGCOUNTS = 1390;  //Entspricht Strecke von 20cm  //DONT TOUCH /1773 //1800 //1350 /////1390

Drive::Drive(KontrastSensor& kontrastSensor, EncoderCounter& counterLeft, EncoderCounter& counterRight, Controller& controller, IRSensor& irSensor0, IRSensor& irSensor1, IRSensor& irSensor2, IRSensor& irSensor3, int& dontStop, int& modeStart, int& path, int& pathNext):
    kontrastSensor(kontrastSensor),
    counterLeft(counterLeft),
    counterRight(counterRight),
    controller(controller),
    irSensor0(irSensor0),
    irSensor1(irSensor1),
    irSensor2(irSensor2),
    irSensor3(irSensor3),
    dontStop(dontStop),
    modeStart(modeStart),
    path(path),
    pathNext(pathNext)

{

}

Drive::~Drive() {}


void Drive::driving()
{

    controller.reset();

    int countsRight = counterRight.read();  //EncoderCounts auslesen
    int countsLeft = counterLeft.read();
    int countsRight0 = countsRight;         //ReferenzCounts setzten
    int countsLeft0 = countsLeft;

    float parallelDif = 0.0f;
    float rightLeftDif = 0.0f;
    float leftDif = 0.0f;
    float rightDif = 0.0f;

    float speedCorrection = 0.0f;
    int countCorrection = 0;

    float softStart = DRIVINGSPEED;
    float slowdown = 0.0f;

    if(dontStop == 2) { //geradeaus
        softStart =0.0f;
        
        /********/
       //countCorrection = -400.0f;
        /*******/
    }

    int drive;


    //Abfangen wenn Wand vorne dass sicher nicht vorwärts gefahren wird

    if(irSensor1.read() < FRONTDISTANCE) {
        drive = 0;
    } else {
        drive = 1;
    }

    while(((countsRight <= countsRight0 + DRIVINGCOUNTS + countCorrection) || (countsLeft >= countsLeft0 - DRIVINGCOUNTS - countCorrection)) && (drive == 1) ) {

        kontrastSensor.check();
        countsRight = counterRight.read();
        countsLeft = counterLeft.read();
        controller.setDesiredSpeedRight(-softStart + DRIVINGSPEED - speedCorrection - slowdown); //Korrektur passt Geschwindigkeit an beiden Raedern an //slowdown
        controller.setDesiredSpeedLeft(softStart - DRIVINGSPEED - speedCorrection + slowdown);  //slowdown


        //Ermittlung der Differenz Hinten-Vorne (PARALLEL)

        if((irSensor3.read() < 120.0f) && (irSensor2.read() < 120.0f)) { //irSensor3 => sensorLeftBack , irSensor2 => sensorLeftFront

            parallelDif = irSensor3.read()-irSensor2.read();    //differenz hinten vorne bestimmen

        } else { //ist wand eine wand nicht vorhanden => keine korrektur

            parallelDif = 0;
        }


        //Ermittlung der Differenz Rechts-Links (LINKS UND RECHTS WAND VORHANDEN)

        if((irSensor0.read() < 120.0f) && (irSensor2.read() < 120.0f)) {  //irSensor0 => sensorRight irSensor2 => sensorLeftFornt

            rightLeftDif = irSensor0.read()-irSensor2.read(); //differenz links rechts bestimmen

        } else { //ist wand eine wand nicht vorhanden => keine korrektur

            rightLeftDif = 0;

            //Ermittlung der Differenz links auf ReferenzWert
            if(irSensor2.read() < 120.0f) {  //irSensor2 => sensorLeftFornt

                leftDif = 60.0f - irSensor2.read(); //differenz links rechts bestimmen

            } else { //ist wand eine wand nicht vorhanden => keine korrektur

                leftDif = 0;
            }


            //Ermittlung der Differenz rechts auf Referenzwert

            if(irSensor0.read() < 120.0f) {  //irSensor0 => sensorRight

                rightDif = irSensor0.read() - 60.0f; //differenz links rechts bestimmen

            } else { //ist wand eine wand nicht vorhanden => keine korrektur

                rightDif = 0;
            }
        }


        //Berechung Korrektur

        speedCorrection = ((0.45f * rightLeftDif) + (0.7f * parallelDif) + (0.9f * leftDif) + (0.9f * rightDif)); //DONT TOUCH 0.35 0.7 0.7 0.7


        //Anfahrrampe damit die Raeder nicht durchdrehen

        softStart = softStart - 3.5f;
        if (softStart <= 0.0f) {
            softStart = 0.0f;
        }


        //Kontrolle ob vorne Wand...wenn vorhanden nach vorderer Wand ausrichten und anhalten ansonst nur nach counts anhalten

        if(irSensor1.read() < 150.0f) { //slow down

            countCorrection = 5000;
            slowdown = slowdown + 5.0f;
            if (slowdown >= DRIVINGSPEED - 20.0f) {

                slowdown = DRIVINGSPEED - 20.0f;
            }
            if (irSensor1.read() < FRONTDISTANCE) {

                drive = 0;
            }

        } else if((((DRIVINGCOUNTS - countsRight) < 250) || ((countsLeft + DRIVINGCOUNTS) < 250)) && ((irSensor2.read() > 120.0f) && ((modeStart != 1) || (pathNext == 2)))) { //Anhaltrampe wenn nach counts gefahren
            slowdown = slowdown + 5.0f;
            if (slowdown >= DRIVINGSPEED - 20.0f) {

                slowdown = DRIVINGSPEED - 20.0f;
}
            } else if((((DRIVINGCOUNTS - countsRight) < 250) || ((countsLeft + DRIVINGCOUNTS) < 250)) && ((irSensor0.read() > 120.0f) && ((modeStart == 1) && (pathNext == 3)))) { //Anhaltrampe wenn nach counts gefahren
                slowdown = slowdown + 5.0f;
                if (slowdown >= DRIVINGSPEED - 20.0f) {

                    slowdown = DRIVINGSPEED - 20.0f;
                }
            } else {

                slowdown = 0.0f;
            }

            wait(0.01f);
        }//Ende Whileschleife Drive...
    }
