#ifndef TURN_H_
#define TURN_H_

#include <cstdlib>
#include <mbed.h>
#include "EncoderCounter.h"
#include "LowpassFilter.h"
#include "Controller.h"

class Turn
{

public:

    Turn(EncoderCounter& counterLeft, EncoderCounter& counterRight, Controller& controller, int& wallRight, int& wallFront, int& wallLeft);
    
    virtual ~Turn();
    void turning();
    
private:

    static const float TURNINGSPEED;
    static const int TURNINGCOUNTS;

    EncoderCounter&    counterLeft;
    EncoderCounter&    counterRight;
    Controller& controller;
    int& wallRight;
    int& wallFront;
    int& wallLeft;
};

#endif /* TURN_H_ */