#include <cmath>
#include "Turn.h"

using namespace std;

const float Turn::TURNINGSPEED = 50.0f;//Drehgeschwindgkeit Drehzahl in [rpm]
const int Turn::TURNINGCOUNTS = 910;  //Entspricht Drehung um 90Grad //DONT TOUCH

Turn::Turn(EncoderCounter& counterLeft, EncoderCounter& counterRight, Controller& controller, int& wallRight, int& wallFront, int& wallLeft):
    counterLeft(counterLeft), 
    counterRight(counterRight),
    controller(controller),
    wallRight(wallRight),
    wallFront(wallFront),
    wallLeft(wallLeft)
{}

Turn::~Turn() {}


void Turn::turning()
{
    int countsRight = counterRight.read();  //EncoderCounts auslesen  
    int countsRight0 = countsRight;         //ReferenzCounts setzten
    int countsLeft = counterLeft.read();
    int countsLeft0 = countsLeft;
    
    //vor dem abbiegen halten
    controller.setDesiredSpeedRight(0.5f);
    controller.setDesiredSpeedLeft(-0.5f);
    //wait(0.1f);
    
    
    
    //Entscheiden welche Richtung, Drehen und Stoppen wenn die gewuenschte Anzahl Counts erreicht sind
    
    if (wallLeft == 0){ //Nach Links Drehen
    
    //printf("Links ist frei\n");
    
    while((countsRight <= countsRight0 + TURNINGCOUNTS) && (countsLeft <= countsLeft0 + TURNINGCOUNTS)){
        controller.setDesiredSpeedRight(TURNINGSPEED);
        controller.setDesiredSpeedLeft(TURNINGSPEED);
        countsRight = counterRight.read();
        countsLeft = counterLeft.read();
        //printf("%d\n\r", countsRight);
        //printf("%d\n\r", countsLeft);
    }
    controller.setDesiredSpeedRight(0.5f);
    controller.setDesiredSpeedLeft(-0.5f);
    
    }else if (wallFront == 0){ //Nicht Drehen-> weiter Geradeaus
    
        //printf("Vorne ist frei\n");
        
        }else if (wallRight == 0) { //Nach Rechts Drehen
            
            //printf("Rechts ist frei\n");
            
            while((countsRight >= countsRight0 - TURNINGCOUNTS) && (countsLeft >= countsLeft0 - TURNINGCOUNTS)){
                controller.setDesiredSpeedRight(-TURNINGSPEED);
                controller.setDesiredSpeedLeft(-TURNINGSPEED);
                countsRight = counterRight.read();
                countsLeft = counterLeft.read();
                //printf("%d\n", countsRight);
                //printf("%d\n", countsLeft);
            }
            controller.setDesiredSpeedRight(0.5f);
            controller.setDesiredSpeedLeft(-0.5f);
            
            
            }else{ //Alle Wege versperrt-> Wenden
            
                //printf("Alles versperrt...zurueck\n");
            
                while((countsRight <= countsRight0 + 2*TURNINGCOUNTS + 70) && (countsLeft <= countsLeft0 + 2*TURNINGCOUNTS + 70)){
                    controller.setDesiredSpeedRight(TURNINGSPEED);
                    controller.setDesiredSpeedLeft(TURNINGSPEED);
                    countsRight = counterRight.read();
                    countsLeft = counterLeft.read();
                    //printf("%d\n", countsRight);
                    //printf("%d\n", countsLeft);
                }
                controller.setDesiredSpeedRight(0.5f);  //0.0f
                controller.setDesiredSpeedLeft(-0.5f);   //0.0f
            }
}
