#include <cmath>
#include "IRSensor.h"

using namespace std;


IRSensor::IRSensor(AnalogIn& distance) :
    distance(distance)
{}

IRSensor::~IRSensor() {}

float IRSensor::read()
{
    double d = distance * 3.3f; // Change the value to be in the 0 to 3300 range
    
    //DONT TOUCH
    //y = 14.098x6 - 147.35x5 + 627.68x4 - 1403.5x3 + 1765.1x2 - 1236.9x + 430.44 POLYNOMFUNKTION AUS EXCEL
    float f = 14.098f*((d)*(d)*(d)*(d)*(d)*(d)) - 147.35f*((d)*(d)*(d)*(d)*(d)) + 627.68*((d)*(d)*(d)*(d)) - 1403.5f*((d)*(d)*(d)) + 1765.1f*((d)*(d)) - 1236.9f*(d) + 430.44f; // Lesen der Distanz in [mm]  
    
    return f;
}