#include "sdcard.h"
#include <stdio.h>
#include <string.h>
#include <math.h>
#include "main.h"

Timer timer;

DigitalIn button(PC_13, PullUp);

SDFileSystem sd(PA_7, PA_6, PA_5, PB_6, "sd", PA_8, SDFileSystem::SWITCH_NONE, 25000000);
char buffer[4096];

void writeTest()
{
    //Test write performance by creating a 1MB file
    printf("Testing %iB write performance...", sizeof(buffer));
    FileHandle* file = sd.open("Test File.bin", O_WRONLY | O_CREAT | O_TRUNC);
    if (file != NULL) {
        timer.start();
        for (int i = 0; i < (1048576 / sizeof(buffer)); i++) {
            if (file->write(buffer, sizeof(buffer)) != sizeof(buffer)) {
                timer.stop();
                printf("write error!\n\r");
                timer.reset();
                return;
            }
        }
        timer.stop();
        if (file->close())
            printf("failed to close file!\n\r");
        else
            printf("done!\n\r\tResult: %.2fKB/s\n\r", 1024 / (timer.read_us() / 1000000.0));
        timer.reset();
    } else {
        printf("failed to create file!\n\r");
    }
}

void readTest()
{
    //Test read performance by reading the 1MB file created by writeTest()
    printf("Testing %iB read performance...", sizeof(buffer));
    FileHandle* file = sd.open("Test File.bin", O_RDONLY);
    if (file != NULL) {
        timer.start();
        int iterations = 0;
        while (file->read(buffer, sizeof(buffer)) == sizeof(buffer))
            iterations++;
        timer.stop();
        if (iterations != (1048576 / sizeof(buffer)))
            printf("read error!\n\r");
        else if (file->close())
            printf("failed to close file!\n\r");
        else if (sd.remove("Test File.bin"))
            printf("failed to delete file!\n\r");
        else
            printf("done!\n\r\tResult: %.2fKB/s\n\r", 1024 / (timer.read_us() / 1000000.0));
        timer.reset();
    } else {
        printf("failed to open file!\n\r");
    }
}

void testSd()
{
    //Configure CRC, large frames, and write validation
    sd.crc(true);
    sd.large_frames(true);
    sd.write_validation(true);

    //Fill the buffer with random data for the write test
    srand(time(NULL));
    for (int i = 0; i < sizeof(buffer); i++)
        buffer[i] = rand();


    //Print the start message
    printf("\n\rStarting SD Card test application:");


    //Make sure a card is present
    if (!sd.card_present()) {
        printf("\n\rNo card present!\n\r");
    }

    //Try to mount the SD card
    printf("\n\rMounting SD card...");
    if (sd.mount() != 0) {
        printf("failed!\n\r");
    }
    printf("success!\n\r");

    //Display the card type
    printf("\tCard type: ");
    SDFileSystem::CardType cardType = sd.card_type();
    if (cardType == SDFileSystem::CARD_NONE)
        printf("None\n\r");
    else if (cardType == SDFileSystem::CARD_MMC)
        printf("MMC\n\r");
    else if (cardType == SDFileSystem::CARD_SD)
        printf("SD\n\r");
    else if (cardType == SDFileSystem::CARD_SDHC)
        printf("SDHC\n\r");
    else
        printf("Unknown\n\r");

    //Display the card capacity
    printf("\tSectors: %u\n\r", sd.disk_sectors());
    printf("\tCapacity: %.1fMB\n\r", sd.disk_sectors() / 2048.0);

    /*//Format the card
    printf("Formatting SD card...");
    if (sd.format() != 0) {
        printf("failed!\n\r");
        continue;
    }
    printf("success!\n\r");*/

    //Perform a read/write test
    writeTest();
    readTest();



    printf("write to SD card on a txt file:\n\r");
    printf("\tHello World!\n\r");

    FILE *fp = fopen("/sd/medication/sdtest.txt", "a");
    if(fp == NULL) {
        printf("\tCould not open file for write\n\r");
    } else {
        printf("\tfile opened\n\r");
    }

    fprintf(fp, "Hello fun SD Card World!\n\r");
    fclose(fp);

    printf("\tText written to SD card\n\r");
    printf("\tGoodbye World!\r\n");

    //Unmount the SD card
    sd.unmount();
}

s_user readMedication(int user)
{
    s_user userfile;
    userfile.valid = false;
    char filepath[] = "/sd/medication/medicationUser2.txt";
    if(user==0) {
        strcpy(filepath, "/sd/medication/medicationUser1.txt");
    }

    //Configure CRC, large frames, and write validation
    sd.crc(true);
    sd.large_frames(true);
    sd.write_validation(true);

    //mount SD card
    printf("\n\rMounting SD card...");
    if (sd.mount() != 0) {
        printf("failed!\n\r");
        return userfile;
    }
    printf("success!\n\r");

    //open file for read
    printf("open file %s...",filepath);
    FILE *fp = fopen(filepath, "r");
    if(fp == NULL) {
        printf("failed!\n\r");
        return userfile;
    }
    printf("success!\n\r");

    char string[STR_LEN];
    int linecounter = 1;
    int checksum = 0;
    int checksum2 = 0;
    while (fgets(string, STR_LEN, fp) != NULL) {
        switch (linecounter) {
            case 1:
                printf("Reading Line 1...");
                strcpy(userfile.firstName, strtok(string, TOKEN));
                strcpy(userfile.secondName, strtok(NULL, TOKEN));
                printf("done!\r\n");
                printf("\tFirst Name:\t%s \n\r\tLast Name:\t%s \n\r", userfile.firstName,userfile.secondName);
                break;
            case 30:
                printf("reading checksum...");
                checksum2 = atoi(strtok(string, TOKEN));
                printf("done!\r\n");
                if(checksum == checksum2) userfile.valid = true;
                break;
            default:
                printf("reading medication %d...",(linecounter-1));
                int daycounter = (linecounter-2)/4;
                int momentcounter = (linecounter-2)%4;

                userfile.medication.day[daycounter].moment[momentcounter].time.hour = atoi(strtok(string, TOKEN));
                userfile.medication.day[daycounter].moment[momentcounter].time.minute = atoi(strtok(NULL, TOKEN));
                userfile.medication.day[daycounter].moment[momentcounter].timeOffsetMinus = atoi(strtok(NULL, TOKEN));
                userfile.medication.day[daycounter].moment[momentcounter].timeOffsetPlus = atoi(strtok(NULL, TOKEN));

                checksum += userfile.medication.day[daycounter].moment[momentcounter].time.hour;
                checksum += userfile.medication.day[daycounter].moment[momentcounter].time.minute;
                checksum += userfile.medication.day[daycounter].moment[momentcounter].timeOffsetMinus;
                checksum += userfile.medication.day[daycounter].moment[momentcounter].timeOffsetPlus;

                int medication = atoi(strtok(NULL, TOKEN));

                for( int ii = 0; ii<6; ii++) {
                    userfile.medication.day[daycounter].moment[momentcounter].medContainer.container[5-ii] = medication % 10;
                    medication = medication/10;
                    checksum += userfile.medication.day[daycounter].moment[momentcounter].medContainer.container[5-ii];
                }
                printf("done!\r\n");
                break;
        }
        linecounter++;
    }
    //close file
    fclose(fp);
    //Unmount the SD card
    sd.unmount();

    return userfile;
}

int writeMedication(int user, s_user userfile)
{

    char filepath[] = "/sd/medication/medicationUser2.txt";
    if(user==0) {
        strcpy(filepath, "/sd/medication/medicationUser1.txt");
    }

    //Configure CRC, large frames, and write validation
    sd.crc(true);
    sd.large_frames(true);
    sd.write_validation(true);

    //mount SD card
    printf("\n\rMounting SD card...");
    if (sd.mount() != 0) {
        printf("failed!\n\r");
        return EXIT_FAILURE;
    }
    printf("success!\n\r");

    //delete file
    //sd.remove(filepath);

    //open file for write
    printf("open file %s...",filepath);
    FILE *fp = fopen(filepath, "w");
    if(fp == NULL) {
        printf("failed!\n\r");
        return EXIT_FAILURE;
    }
    printf("success!\n\r");
    printf("writing to SD card...");
    fprintf(fp,"%s;%s",userfile.firstName,userfile.secondName);
    int checksum = 0;
    for(int i = 2; i< 30; i++) {
        int daycounter = (i-2)/4;
        int momentcounter = (i-2)%4;
        int hour = userfile.medication.day[daycounter].moment[momentcounter].time.hour;
        int minute = userfile.medication.day[daycounter].moment[momentcounter].time.minute;
        int offsetMinus = userfile.medication.day[daycounter].moment[momentcounter].timeOffsetMinus;
        int offsetPlus = userfile.medication.day[daycounter].moment[momentcounter].timeOffsetPlus;
        checksum += hour+minute+offsetMinus+offsetPlus;
        int medication = 0;
        for(int ii = 0; ii < 6; ii++) {
            int devider = pow(10.0f,ii);
            medication += 100000/devider * userfile.medication.day[daycounter].moment[momentcounter].medContainer.container[ii];
            checksum+=userfile.medication.day[daycounter].moment[momentcounter].medContainer.container[ii];
        }
        fprintf(fp,"%02d;%02d;%02d;%02d;%06d\r\n",hour, minute,offsetMinus, offsetPlus, medication);

    }
    fprintf(fp,"%d",checksum);
    printf("done!\r\n");

    //close file
    printf("closing file %s...",filepath);
    fclose(fp);
    printf("done!\n\r");
    //Unmount the SD card
    printf("Unmounting SD card...");
    sd.unmount();
    printf("done!\n\r");

    return EXIT_SUCCESS;
}


int write_medProtocol(s_time medicationTime, s_time outputTime, s_medContainer medication, int success, char user)
{
    char filepath[] = "/sd/protocol/medProtocolUser2.txt";              // Muss noch auf SD Karte erstellt werden!!!
    if(user==0) {
        strcpy(filepath, "/sd/protocol/medProtocolUser1.txt");           // Muss noch auf SD Karte erstellt werden!!!
    }

    //Configure CRC, large frames, and write validation
    sd.crc(true);
    sd.large_frames(true);
    sd.write_validation(true);

    //mount SD card
    printf("\n\rMounting SD card...");
    if (sd.mount() != 0) {
        printf("failed!\n\r");
        return EXIT_FAILURE;
    }
    printf("success!\n\r");

    //open file for append
    printf("open file %s...",filepath);
    FILE *fp = fopen(filepath, "a");
    if(fp == NULL) {
        printf("failed!\n\r");
        return EXIT_FAILURE;
    }
    printf("success!\n\r");
    printf("writing to SD card...");
    fprintf(fp,"%d;%02d;%02d;%02d;%02d;%02d;%d;%02d;%02d;",outputTime.weekday,outputTime.day,outputTime.month,outputTime.year,medicationTime.hour,medicationTime.minute,success,outputTime.hour,outputTime.minute);
    fprintf(fp,"%d%d%d%d%d%d\r\n", medication.container[0], medication.container[1], medication.container[2], medication.container[3], medication.container[4], medication.container[5]);

    printf("done!\r\n");

    //close file
    printf("closing file %s...",filepath);
    fclose(fp);
    printf("done!\n\r");
    //Unmount the SD card
    printf("Unmounting SD card...");
    sd.unmount();
    printf("done!\n\r");

    return EXIT_SUCCESS;
}

int erase_medProtocol()
{
    char filepath[] = "/sd/protocol/medProtocolUser1.txt";

    //Configure CRC, large frames, and write validation
    sd.crc(true);
    sd.large_frames(true);
    sd.write_validation(true);

    //mount SD card
    printf("\n\rMounting SD card...");
    if (sd.mount() != 0) {
        printf("failed!\n\r");
        return EXIT_FAILURE;
    }

    //open file for write
    printf("\n\ropen file %s...",filepath);
    FILE *fp = fopen(filepath, "w");
    if(fp == NULL) {
        printf("failed!\n\r");
        return EXIT_FAILURE;
    }

    //close file
    printf("\n\rclosing file %s...",filepath);
    fclose(fp);

    strcpy(filepath, "/sd/protocol/medProtocolUser2.txt");

    //open file for write
    printf("\n\ropen file %s...",filepath);
    fp = fopen(filepath, "w");
    if(fp == NULL) {
        printf("failed!\n\r");
        return EXIT_FAILURE;
    }

    //close file
    printf("closing file %s...",filepath);
    fclose(fp);

    sd.unmount();

    printf("done");

    return EXIT_SUCCESS;
}

//int write_medInventory(s_medContainer medInventory, s_time currentTime, char med1[], char med2[], char med3[], char med4[], char med5[], char med6[])
int write_medInventory(s_medInventory medInventory)
{
    char filepath[] = "/sd/protocol/medInventory.txt";              // Muss noch auf SD Karte erstellt werden!!!

    //Configure CRC, large frames, and write validation
    sd.crc(true);
    sd.large_frames(true);
    sd.write_validation(true);

    //mount SD card
    printf("\n\rMounting SD card...");
    if (sd.mount() != 0) {
        printf("failed!\n\r");
        return EXIT_FAILURE;
    }
    printf("success!\n\r");

    //open file for write
    printf("open file %s...",filepath);
    FILE *fp = fopen(filepath, "w");
    if(fp == NULL) {
        printf("failed!\n\r");
        return EXIT_FAILURE;
    }
    printf("success!\n\r");
    printf("writing to SD card...");
    fprintf(fp,"%d\r\n", medInventory.userNumber);    
    fprintf(fp,"%s\r\n", medInventory.pill[0]);
    fprintf(fp,"%02d\r\n",medInventory.medContainer.container[0]);
    fprintf(fp,"%s\r\n", medInventory.pill[1]);
    fprintf(fp,"%02d\r\n",medInventory.medContainer.container[1]);
    fprintf(fp,"%s\r\n", medInventory.pill[2]);
    fprintf(fp,"%02d\r\n",medInventory.medContainer.container[2]);
    fprintf(fp,"%s\r\n", medInventory.pill[3]);
    fprintf(fp,"%02d\r\n",medInventory.medContainer.container[3]);
    fprintf(fp,"%s\r\n", medInventory.pill[4]);
    fprintf(fp,"%02d\r\n",medInventory.medContainer.container[4]);
    fprintf(fp,"%s\r\n", medInventory.pill[5]);
    fprintf(fp,"%02d\r\n",medInventory.medContainer.container[5]);
    fprintf(fp,"%02d;%02d;%02d;%02d;%02d;\r\n", medInventory.currentTime.day, medInventory.currentTime.month, medInventory.currentTime.year, medInventory.currentTime.hour, medInventory.currentTime.minute);

    printf("done!\r\n");

    //close file
    printf("closing file %s...",filepath);
    fclose(fp);
    printf("done!\n\r");
    //Unmount the SD card
    printf("Unmounting SD card...");
    sd.unmount();
    printf("done!\n\r");

    return EXIT_SUCCESS;
}

int write_medError(char error[], s_time time)
{
    char filepath[] = "/sd/protocol/Error.txt";              

    //Configure CRC, large frames, and write validation
    sd.crc(true);
    sd.large_frames(true);
    sd.write_validation(true);

    //mount SD card
    printf("\n\rMounting SD card...");
    if (sd.mount() != 0) {
        printf("failed!\n\r");
        return EXIT_FAILURE;
    }
    printf("success!\n\r");

    //open file for append
    printf("open file %s...",filepath);
    FILE *fp = fopen(filepath, "a");
    if(fp == NULL) {
        printf("failed!\n\r");
        return EXIT_FAILURE;
    }
    printf("success!\n\r");
    printf("writing to SD card...");
    fprintf(fp,"%02d;%02d;%02d;%02d;%02d;%s\r\n", time.day, time.month, time.year, time.hour, time.minute, error);

    printf("done!\r\n");

    //close file
    printf("closing file %s...",filepath);
    fclose(fp);
    printf("done!\n\r");
    //Unmount the SD card
    printf("Unmounting SD card...");
    sd.unmount();
    printf("done!\n\r");

    return EXIT_SUCCESS;
}

int erase_medError()
{
    char filepath[] = "/sd/protocol/Error.txt";

    //Configure CRC, large frames, and write validation
    sd.crc(true);
    sd.large_frames(true);
    sd.write_validation(true);

    //mount SD card
    printf("\n\rMounting SD card...");
    if (sd.mount() != 0) {
        printf("failed!\n\r");
        return EXIT_FAILURE;
    }

    //open file for write
    printf("open file %s...",filepath);
    FILE *fp = fopen(filepath, "w");
    if(fp == NULL) {
        printf("failed!\n\r");
        return EXIT_FAILURE;
    }

    //close file
    printf("closing file %s...",filepath);
    fclose(fp);

    sd.unmount();

    printf("done");

    return EXIT_SUCCESS;
}

char *read_medProtocol(char user)
{

    static char    *buff;
    long    numbytes;

    char filepath[] = "/sd/protocol/medProtocolUser2.txt";
    if(user==0) {
        strcpy(filepath, "/sd/protocol/medProtocolUser1.txt");
    }

    //Configure CRC, large frames, and write validation
    sd.crc(true);
    sd.large_frames(true);
    sd.write_validation(true);

    //mount SD card
    printf("\n\rMounting SD card...");
    if (sd.mount() != 0) {
        printf("failed!\n\r");
        return NULL;
    }
    printf("success!\n\r");

    //open file for read
    printf("open file %s...",filepath);
    FILE *fp = fopen(filepath, "r");
    if(fp == NULL) {
        printf("failed!\n\r");
        return NULL;
    }
    printf("success!\n\r");

    /* Get the number of bytes */
    fseek(fp, 0L, SEEK_END);
    numbytes = ftell(fp);

    /* reset the file position indicator to
    the beginning of the file */
    fseek(fp, 0L, SEEK_SET);

    /* grab sufficient memory for the
    buffer to hold the text */
    buff = (char*)calloc(numbytes, sizeof(char));


    /* copy all the text into the buffer */
    fread(buff, sizeof(char), numbytes-1, fp);
    fclose(fp);

    /* free the memory we used for the buffer */
    //free(buff);

    //Unmount the SD card
    sd.unmount();

    return buff;
}


s_medInventory read_medInventory()
{
    s_medInventory Inventory;

    char filepath[] = "/sd/protocol/medInventory.txt";

    //Configure CRC, large frames, and write validation
    sd.crc(true);
    sd.large_frames(true);
    sd.write_validation(true);

    //mount SD card
    printf("\n\rMounting SD card...");
    if (sd.mount() != 0) {
        printf("failed!\n\r");
        return Inventory;
    }
    printf("success!\n\r");

    //open file for read
    printf("open file %s...",filepath);
    FILE *fp = fopen(filepath, "r");
    if(fp == NULL) {
        printf("failed!\n\r");
        return Inventory;
    }
    printf("success!\n\r");

    char *str;

    int linecounter = 1;
    int line = 3;
    int i = 0;

    while (fgets(str, 50, fp) != NULL) {

        switch (line) {
            case 1:
                if(linecounter != 14) {
                    strcpy(Inventory.pill[i], strtok(str, "\r"));
                    line = 2;
                }

                break;

            case 2:
                Inventory.medContainer.container[i] = atoi(strtok(str, "\r"));
                line =1;
                i++;
                break;
                
            case 3:
                Inventory.userNumber = atoi(strtok(str, "\r"));
                line = 1;

                break;
        }
        linecounter++;
    }
    //close file
    fclose(fp);
    //Unmount the SD card
    sd.unmount();

    return Inventory;
}


char *read_medError()
{
    static char    *buff;
    long    numbytes;

    char filepath[] = "/sd/protocol/Error.txt";


    //Configure CRC, large frames, and write validation
    sd.crc(true);
    sd.large_frames(true);
    sd.write_validation(true);

    //mount SD card
    printf("\n\rMounting SD card...");
    if (sd.mount() != 0) {
        printf("failed!\n\r");
        return NULL;
    }
    printf("success!\n\r");

    //open file for read
    printf("open file %s...",filepath);
    FILE *fp = fopen(filepath, "r");
    if(fp == NULL) {
        printf("failed!\n\r");
        return NULL;
    }
    printf("success!\n\r");

    /* Get the number of bytes */
    fseek(fp, 0L, SEEK_END);
    numbytes = ftell(fp);

    /* reset the file position indicator to
    the beginning of the file */
    fseek(fp, 0L, SEEK_SET);

    /* grab sufficient memory for the
    buffer to hold the text */
    buff = (char*)calloc(numbytes, sizeof(char));


    /* copy all the text into the buffer */
    fread(buff, sizeof(char), numbytes-1, fp);
    fclose(fp);

    /* free the memory we used for the buffer */
    //free(buff);

    //Unmount the SD card
    sd.unmount();

    return buff;
}

char *read_Inventory()
{
    static char    *buff;
    long    numbytes;

    char filepath[] = "/sd/protocol/medInventory.txt";

    //Configure CRC, large frames, and write validation
    sd.crc(true);
    sd.large_frames(true);
    sd.write_validation(true);

    //mount SD card
    printf("\n\rMounting SD card...");
    if (sd.mount() != 0) {
        printf("failed!\n\r");
        return NULL;
    }
    printf("success!\n\r");

    //open file for read
    printf("open file %s...",filepath);
    FILE *fp = fopen(filepath, "r");
    if(fp == NULL) {
        printf("failed!\n\r");
        return NULL;
    }
    printf("success!\n\r");

    /* Get the number of bytes */
    fseek(fp, 0L, SEEK_END);
    numbytes = ftell(fp);

    /* reset the file position indicator to
    the beginning of the file */
    fseek(fp, 0L, SEEK_SET);

    /* grab sufficient memory for the
    buffer to hold the text */
    buff = (char*)calloc(numbytes, sizeof(char));


    /* copy all the text into the buffer */
    fread(buff, sizeof(char), numbytes-1, fp);
    fclose(fp);

    /* free the memory we used for the buffer */
    //free(buff);

    //Unmount the SD card
    sd.unmount();

    return buff;
}


char *read_Medication(char user)
{
    static char    *buff;
    long    numbytes;
    
    char filepath[] = "/sd/medication/medicationUser2.txt";
    if(user==0) {
        strcpy(filepath, "/sd/medication/medicationUser1.txt");
    }

    //Configure CRC, large frames, and write validation
    sd.crc(true);
    sd.large_frames(true);
    sd.write_validation(true);

    //mount SD card
    printf("\n\rMounting SD card...");
    if (sd.mount() != 0) {
        printf("failed!\n\r");
        return NULL;
    }
    printf("success!\n\r");

    //open file for read
    printf("open file %s...",filepath);
    FILE *fp = fopen(filepath, "r");
    if(fp == NULL) {
        printf("failed!\n\r");
        return NULL;
    }
    printf("success!\n\r");

    /* Get the number of bytes */
    fseek(fp, 0L, SEEK_END);
    numbytes = ftell(fp);

    /* reset the file position indicator to
    the beginning of the file */
    fseek(fp, 0L, SEEK_SET);

    /* grab sufficient memory for the
    buffer to hold the text */
    buff = (char*)calloc(numbytes, sizeof(char));

    /* copy all the text into the buffer */
    fread(buff, sizeof(char), numbytes-1, fp);
    fclose(fp);

    /* free the memory we used for the buffer */
    //free(buff);

    //Unmount the SD card
    sd.unmount();

    return buff;
}
