#include "measure.h"
#include "functions.h"


/*  Interrupts for DutyCycle */
InterruptIn iRuptServo1(PB_2);
InterruptIn iRuptServo2(PB_1);
InterruptIn iRuptServo3(PB_15);
InterruptIn iRuptServo4(PB_14);
InterruptIn iRuptServo5(PB_13);
InterruptIn iRuptServo6(PC_4);


/* Timer */
Timer t;

/* Variables */
float timePWM;
float periodPWM;
int startDutyCycle[7];


/*  Write Time for PWM
*   @ Write to global variable
*/
void writeTime()
{
    timePWM = t.read();
}

/*  Write Period for PWM
*   @ Write to global variable
*/
void writePeriod()
{
    periodPWM = t.read();
    t.reset();
}

/*  Disable all Container */
void disableContainer()
{
    t.stop();
    t.reset();
    iRuptServo1.disable_irq();
    iRuptServo2.disable_irq();
    iRuptServo3.disable_irq();
    iRuptServo4.disable_irq();
    iRuptServo5.disable_irq();
    iRuptServo6.disable_irq();
}

/*  Enable Container
*   @param  Container 1-6
*/
void enableContainer(char container)
{
    t.start();
    switch (container) {
        case 1:
            iRuptServo1.enable_irq();
            break;
        case 2:
            iRuptServo2.enable_irq();
            break;
        case 3:
            iRuptServo3.enable_irq();
            break;
        case 4:
            iRuptServo4.enable_irq();
            break;
        case 5:
            iRuptServo5.enable_irq();
            break;
        case 6:
            iRuptServo6.enable_irq();
            break;
        default:
            printf("You entered a wrong container number!\n\r");
            break;
    }

}

/*  Get DutyCycle
*   @return DutyCycle in promille
*/
int getDutyCycle()
{
    int dutyCycle = (int)(1000.0f * timePWM / periodPWM);
    return dutyCycle;
}

/*  Attach Interrupts */
void initInterrupt()
{
    iRuptServo1.rise(&writeTime);
    iRuptServo2.rise(&writeTime);
    iRuptServo3.rise(&writeTime);
    iRuptServo4.rise(&writeTime);
    iRuptServo5.rise(&writeTime);
    iRuptServo6.rise(&writeTime);

    iRuptServo1.fall(&writePeriod);
    iRuptServo2.fall(&writePeriod);
    iRuptServo3.fall(&writePeriod);
    iRuptServo4.fall(&writePeriod);
    iRuptServo5.fall(&writePeriod);
    iRuptServo6.fall(&writePeriod);

    for(int i = 1; i <= 6; i++) {
        disableContainer();
        enableContainer(i);
        wait_ms(200);                           // Wichtig: für DutyCycle-Messung
        startDutyCycle[i] = getDutyCycle();
    }
}

/*  Turn Container 90 degrees
*   @param  Container 1-6
*   @return 0 if next position reached
*/
int nextPosition(char container)
{
    enableContainer(container);
    int stopDutyCycle;
    int actDutyCycle;
    if(startDutyCycle[container] < (708+27)) {                  //Im 1. Quadrant + 1/4u
        stopDutyCycle = startDutyCycle[container] + 236;
    }          // Vierteldrehung 236 promille
    else {                                                      //Im 4. Quadrant Übergang in 1. Quadrant
        stopDutyCycle = startDutyCycle[container] -708;
    }
    printf("before setSpeed");

    setSpeed(container, 2);    // Vorwärts drehen
    printf("after setSpeed");
    while((actDutyCycle < stopDutyCycle) || ((actDutyCycle > (708 + 27)) && (stopDutyCycle < (236 + 27)))) {
        actDutyCycle = getDutyCycle();
        printf("Aktueller DutyCycle: %d\n\r", actDutyCycle);
        printf("Start DutyCycle: %d\n\r", startDutyCycle[container]);
    }
    setSpeed(container, 0);    // Bewegung halt
    startDutyCycle[container] = stopDutyCycle;
    disableContainer();
    return 0;
}