#include "main.h"
#define     FADESPEED   4
#define     DEMOTIME    20

int state = 44;     // 44 für Initialisierung!

int oldState;

Serial pc(USBTX, USBRX,460800);

DigitalIn   lichtschranke(PC_5);
InterruptIn userButton1(PB_5);
InterruptIn userButton2(PB_4);
DigitalIn   glasDetection(PA_10);
PwmOut      summer(PC_8);

/* PWM Test Tool */
int channel;
int dutyCycle;
int day;
int moment;
s_user prescription[2];

/* Demo Tool */
uint32_t color = 0;
int colorTime = 0;
int r,b,g;

/* SD write Test*/
s_time medicationTime;
s_time outputTime;
s_time currentTime;
s_medContainer medication;
s_medInventory medInventory;
int success = 1;
char user = 1;
char fail[] = "shit happens";
char *send;


/* Switch Summer On/Off for demo Tool (Interrupt)*/
extern int countcount = 0;
void summ(void)                         // IRQ Routine
{
    userButton1.disable_irq();
    if(summer.read()>0) {
        summer.write(0.0f);
    } else {
        summer.write(0.5f);
    }
    countcount++;
    printf("%d interrupt\n\r",countcount);
    wait_ms(200);
    userButton1.enable_irq();
}



int main()
{
    
    /* SD write Test*/

    medication.container[0] = 1;
    medication.container[1] = 2;
    medication.container[2] = 2;
    medication.container[3] = 1;
    medication.container[4] = 1;
    medication.container[5] = 2;

    /*
        medInventory.container[0] = 5;
        medInventory.container[1] = 10;
        medInventory.container[2] = 15;
        medInventory.container[3] = 20;
        medInventory.container[4] = 25;
        medInventory.container[5] = 30;
    */
    /************/


    printf("start...\r\n");

    while(1) {
        if(state != oldState) {
            printf("\r\nstate: %d\r\n",state);
            oldState = state;
        }
        switch (state) {
            case 0:
                printf("Hello World");
                state = 47;
                break;

            case 1:
                break;

            case 2:
                break;
            case 3:
                break;

            case 10:
                break;
            case 11:
                break;

            case 15:
                break;
            case 16:
                break;
            case 17:
                break;

            case 25:
                break;
            case 26:
                break;
            case 27:
                break;
            case 28:
                break;


            case 35:
                break;
            case 36:
                break;
            case 37:
                break;
            case 38:
                break;


                /**************************************************************/
                /* Test Zone */

                /* Speedtest Servo */
            case 41:
                setSpeed(1, 2);
                wait(3);
                setSpeed(1, 0);
                wait(2);
                setSpeed(1, 1);
                wait(3);
                state = 43;
                break;

                /* DutyCycle */
            case 42:
                printf("case 42:\r\n");
                initInterrupt();
                printf("initInterrupt\r\n");
                enableContainer(1);
                while(1) {
                    printf("%i\r\n", getDutyCycle());
                    printf("--- END ---\r\n");
                    wait(0.2);
                }
                break;

                /* Drehung 90° */
            case 43:
                printf("case 43:\r\n");
                initInterrupt();
                printf("initInterrupt\r\n");
                enableContainer(1);
                while(1) {
                    nextPosition(1);
                    printf("--- END ---\r\n");
                    wait(3);
                }
                break;

                /* init PWM board */
            case 44:
                printf("Init PWM\r\n");
                initPWM(50);
                enableOutput();
                state = 47; // 47 for state switch
                break;

                /* Time test tool: set Time */
            case 45:
                s_time time;
                time.second     =   30;
                time.minute     =   53;
                time.hour       =   12;
                time.day        =   27;
                time.weekday    =   2;
                time.month      =   3;
                time.year       =   18;
                printf("set now time\r\n");
                setTime(&time);
                printf("read time: %02d:%02d:%02d, %02d.%02d.20%02d, weekday: %d\r\n",time.hour, time.minute, time.second, time.day, time.month, time.year, time.weekday);
                state = 47;
                printf("change state to: %d\r\n",state);
                break;

                /* Time test tool: get Time */
            case 46:
                wait(5);
                time = getTime();
                printf("read time: %02d:%02d:%02d, %02d.%02d.20%02d, weekday: %d\r\n",time.hour, time.minute, time.second, time.day, time.month, time.year, time.weekday);
                state = 47;
                break;

                /* Console State Switch */
            case 47:
                printf("\n\rState Switch: Enter next State: \n\r");
                printf("41\tSet Speed Function test\n\r");
                printf("42\tGet Duty Cycle Function test\n\r");
                printf("43\tTurn 90deg Function test\n\r");
                printf("44\tInit Servoboard\n\r");
                printf("45\tset Time\n\r46\tread Time\n\r47\tState Switch\n\r48\tServo Board Test Tool\n\r");
                printf("49\tenable servo output\n\r50\tdisable servo output\n\r");
                printf("51\ttest SD Card\n\r52\tread medication\n\r53\tMedication display test tool\n\r");
                printf("54\tWrite Medication\n\r55\tDemo Tool for Summer and RGB LED\n\r");
                printf("60\tWrite Medication Protocol\n\r");
                printf("61\twrite_medInventory\n\r");
                printf("62\twrite_medError\n\r");
                printf("63\terase_errorPotocol\n\r");
                printf("64\terase_medPotocol\n\r");
                printf("65\tread_medPotocol\n\r");
                printf("66\tread_medInventory\n\r");
                printf("67\tread_medError\n\r");
                printf("68\tread_Inventory\n\r");

                scanf("%d", &state);
                printf("Switch to State %d\n\r",state);
                fflush(stdin);
                break;

                /* Servo-Board Test Tool */
            case 48:
                printf("\n\r\n\rServo-Board Test Tool\n\rEnter Channel Number and then Duty Cycle\n\r");
                printf("for exit, enter Channel > 15\n\r");
                channel = 0;
                while (channel < 16) {
                    printf("Channel Number: ");
                    scanf("%d", &channel);
                    printf("\r\nchannel: %d\n\rDuty Cycle 0..4095: ",channel);
                    scanf("%d", &dutyCycle);
                    printf("\n\r%d\n\r",dutyCycle);
                    setPWM((char)channel, (int)dutyCycle);
                    fflush(stdin);
                }
                printf("leave Servo-Board Test Tool\n\r");
                state = 47;
                break;

            case 49:
                enableOutput();
                printf("Servo output enabled\r\n\n");
                state = 47;
                break;

            case 50:
                disableOutput();
                printf("Servo output disabled\r\n\n");
                state = 47;
                break;

            case 51:
                testSd();
                printf("\rSD Card test finished\r\n\n");
                state = 47;
                break;


            case 52:
                prescription[1] = readMedication(1);
                if(prescription[1].valid) {
                    printf("\rread successful\r\n\n");
                } else {
                    printf("\rread failed\r\n\n");
                }
                state = 47;
                break;

            case 53:
                if(prescription[1].valid == false) {
                    printf("\r\nNo valid data in struct, try to run case 52\r\n\n");
                } else {
                    printf("\r\nMedication display test tool:\r\n");
                    printf("Enter Day (0..6) and Moment (0..4)\r\nTo exit enter Day > 6:\r\n");
                    day = 0;
                    while (day < 7) {
                        printf("\r\nDay Number: ");
                        scanf("%d", &day);
                        if(day < 7) {
                            printf("\r\nDay: %d\n\rMoment 0..3: ",day);
                            scanf("%d", &moment);
                            printf("\r\nMedication for weekday %d Moment %d is ",day,moment);
                            for(int i=0; i<6; i++) {
                                printf("%d", prescription[1].medication.day[day].moment[moment].medContainer.container[i]);
                            }
                            printf("\r\nThe alarm clock is set for %02d:%02d",prescription[1].medication.day[day].moment[moment].time.hour,prescription[1].medication.day[day].moment[moment].time.minute);
                        }
                        printf("\r\n");
                        fflush(stdin);
                    }
                    printf("exit Tool\n\r");
                }
                state = 47;
                break;
            case 54:
                writeMedication(0,prescription[1]);
                state = 47;
                break;
            case 55:
                /* Demo Tool */
                enableOutput();
                printf("Servo output enabled\r\n\n");
                summer.period_us(500);
                summer.write(0.5f);
                wait(1);
                summer.write(0.0f);

                userButton1.fall(&summ);

                printf("Summer Interrupt on Button 0 enabled\n\r");

                color = 0xFFFFFF;
                colorTime = 0;
                setLED(0,color);
                wait(5);

                printf("start fading loop for %d loops\n\r",DEMOTIME);
                while(colorTime < DEMOTIME) {
                    for(r = 0; r < 255; r++) {
                        color &= 0x00FFFF;
                        color |= (r<<16);
                        setLED(0,color);
                        wait_ms(FADESPEED);
                    }
                    for(b = 255; b >= 0; b--) {
                        color &= 0xFFFF00;
                        color |= b;
                        setLED(0,color);
                        wait_ms(FADESPEED);
                    }
                    for(g = 0; g < 255; g++) {
                        color &= 0xFF00FF;
                        color |= (g<<8);
                        setLED(0,color);
                        wait_ms(FADESPEED);
                    }
                    for(r = 255; r > 0; r--) {
                        color &= 0x00FFFF;
                        color |= (r<<16);
                        setLED(0,color);
                        wait_ms(FADESPEED);
                    }
                    for(b = 0; b < 255; b++) {
                        color &= 0xFFFF00;
                        color |= b;
                        setLED(0,color);
                        wait_ms(FADESPEED);
                    }
                    for (g = 255; g > 0; g--) {
                        color &= 0xFF00FF;
                        color |= (g<<8);
                        setLED(0,color);
                        wait_ms(FADESPEED);
                    }
                    colorTime++;
                }
                printf("exit demo tool\n\r");
                state = 47;
                break;

            case 60:
                outputTime = getTime();
                medicationTime = getTime();
                printf("write_medProtocol\n\r");
                write_medProtocol(medicationTime, outputTime, medication, success, user);
                printf("done\n\r");
                state = 47;

                break;

            case 61:
                medInventory.currentTime = getTime();
                printf("write_medInventory\n\r");
                //write_medInventory(medInventory,currentTime,med1,med2,med3,med4,med5,med6);
                write_medInventory(medInventory);
                state = 47;

                break;

            case 62:
                printf("write_medError\n\r");
                write_medError(fail, medicationTime);
                state = 47;

                break;

            case 63:
                printf("erase_errorPotocol\n\r");
                erase_medError();
                state = 47;

                break;

            case 64:
                printf("erase_medPotocol\n\r");
                erase_medProtocol();
                state = 47;

                break;


            case 65:
                printf("read_medPotocol\n\r");
                send = read_medProtocol(user);
                printf("%s", send);
                state = 47;

                break;

            case 66:
                printf("read_medInventory\n\r");
                medInventory = read_medInventory();
                printf("done\r\n");
                printf("%s\r\n%d\r\n%s\r\n%d\r\n%s\r\n%d\r\n%s\r\n%d\r\n%s\r\n%d\r\n%s\r\n%d\r\n", medInventory.pill[0], medInventory.medContainer.container[0], medInventory.pill[1], medInventory.medContainer.container[1], medInventory.pill[2], medInventory.medContainer.container[2], medInventory.pill[3], medInventory.medContainer.container[3], medInventory.pill[4], medInventory.medContainer.container[4], medInventory.pill[5], medInventory.medContainer.container[5]);
                state = 47;

                break;

            case 67:
                printf("read_medError\n\r");
                send = read_medError();
                printf("%s", send);
                state = 47;

                break;

            case 68:
                printf("read_Inventory\n\r");
                send = read_Inventory();
                printf("%s", send);
                state = 47;

                break;

            default:
                state = 47; /* Go to State Switch */
                break;
        }
    }
    printf("exit while 1 loop");
}