#include "i2c.h"


I2C i2c(PB_9, PB_8);

DigitalOut PwmOutputEnable(PC_9);

void initPWM(int8_t freq)
{
    char data[2];
    //Reset
    data[0] = (char) MODE1;
    data[1] = (char) SLEEP;
    i2c.write((ADRESS<<1), data,2);

    wait_ms(1);

    float prescaleval = 25000000.0;     //25MHz
    prescaleval /= 4096.0f;             //12-Bit
    prescaleval /= (float)freq;
    prescaleval -= 1.0f;
    char prescale = (char)(prescaleval);    //0x64 bei 50Hz

    data[0] = (char) PRESCALE;
    data[1] = prescale;
    i2c.write((ADRESS<<1), data,2);

    data[0] = (char) MODE1;
    data[1] = 0x00;             //wake up
    i2c.write((ADRESS<<1), data,2);

    wait_ms(1);

    data[0] = (char) MODE1;
    data[1] = 0x80;             //do restart
    i2c.write((ADRESS<<1), data,2);

    wait_ms(1);

    data[0] = (char) MODE2;
    data[1] = (char) 0x04;
    i2c.write((ADRESS<<1), data,2);

    wait_ms(1);

    printf("init pwm module done...\r\n");
}

void setPWM(char channel, int dutyCycle)
{
    char data[2];
    int16_t wert1 = (dutyCycle>>8);
    int16_t wert2 = (dutyCycle & 0xFF);
    wait(0.002f);

    data[0] = (char)LED0_ON_L+(4*channel);
    data[1] = 0x00;
    i2c.write((ADRESS<<1), data,2);

    data[0] = (char)LED0_ON_H+(4*channel);
    data[1] = 0x00;
    i2c.write((ADRESS<<1), data,2);

    data[0] = (char)LED0_OFF_L+(4*channel);
    data[1] = (char)wert2;
    i2c.write((ADRESS<<1), data,2);

    data[0] = (char)LED0_OFF_H+(4*channel);
    data[1] = (char)wert1;
    i2c.write((ADRESS<<1), data,2);
}

int getPWM(uint8_t channel)
{
    char read = 255;
    char secondread = 255;
    char data;
    data = (char)(LED0_ON_L+(channel<<2));
    i2c.write((ADRESS<<1), &data, 1, 1);
    i2c.read((ADRESS<<1), &read, 1, 0);
    data = (char)(LED0_ON_H+(channel<<2));
    i2c.write((ADRESS<<1), &data, 1, 1);
    i2c.read((ADRESS<<1), &secondread, 1, 0);
    printf("\n\rLED %d ON_L: %x ON_H: %x\r\n",channel, read, secondread);
    return (int)read;
}

int getPRESCALE(void)
{
    char read = 255;
    char data;
    data = (char)(PRESCALE);
    i2c.write((ADRESS<<1), &data, 1, 1);
    i2c.read((ADRESS<<1), &read, 1, 0);
    printf("read Prescale value: >>%x<<\r\n",read);
    return (int)read;
}

void enableOutput(void)
{
    PwmOutputEnable = PwmOn;
}

void disableOutput(void)
{
    PwmOutputEnable = PwmOff;
}

/******************************************************************************/
void initTime(void)
{



}







void setTime(s_time* time)
{
    char data[8];

    data[0] = (char) REG_SECOND;

    data[1] =   bin2bcd(time->second);
    data[2] =   bin2bcd(time->minute);
    data[3] =   bin2bcd(time->hour);
    data[4] =   bin2bcd(time->day);
    data[5] =   bin2bcd(time->weekday);
    data[6] =   bin2bcd(time->month);
    data[7] =   bin2bcd(time->year);

    i2c.write((ADRESS_RTC<<1),data,8);
}


s_time getTime(void) {
    s_time time;

    char read[7];
    char data;
    data = (char)(REG_SECOND);
    i2c.write((ADRESS_RTC<<1), &data, 1, 1);
    i2c.read((ADRESS_RTC<<1), read, 7, 0);

    
    time.second     =   bcd2bin(read[0]&0x7F);
    time.minute     =   bcd2bin(read[1]&0x7F);
    time.hour       =   bcd2bin(read[2]&0x3F);
    time.day        =   bcd2bin(read[3]&0x3F);
    time.weekday    =   bcd2bin(read[4]&0x07);
    time.month      =   bcd2bin(read[5]&0x0F);
    time.year       =   bcd2bin(read[6]);

    return time;
}


char bin2bcd(char binaryValue)
{
    char bcdValue=0;
    char base=0;

    while (binaryValue>0) {
        bcdValue |= (binaryValue%10)<<base;
        base += 4;
        binaryValue /= 10;
    }
    return bcdValue;
}

char bcd2bin(char bcdValue)
{
    char binaryValue = bcdValue& 0x0F;
    while (bcdValue>=0x10) {
        binaryValue += 10;
        bcdValue -= 0x10;
    }
    return binaryValue;
}





