#include "functions.h"

void setLED(char button, uint32_t color)
{
    /* 0xFF - 4095, 0x00 - 0 -> factor 1/16.06 */
    uint16_t red =     (uint16_t)(((color >> 16) & 0xff)<<4);
    uint16_t green =   (uint16_t)(((color >> 8) & 0xff)<<4);
    uint16_t blue =    (uint16_t)((color & 0xff)<<4);
    
    /* PWM channel 10-15, Button is 0 or 1
    * -> if Button = 0, set Channel 10,11,12
    * -> if Button = 1, set Channel 13,14,15
    */
    
    setPWM(9+(3*button) , red);
    setPWM(9+(3*button)+1 , green);
    setPWM(9+(3*button)+2 , blue);

}


void setValvePosition(char pos)
{
    /* 1ms = 0° = 218E, 2ms = 180° = 436E; 1E = 4.59us */
    switch(pos) {
        case 0:                 // neutrale Position
            setPWM(0, 218);
            break;
        case 1:                 // Glas
            setPWM(0, 326);
            break;
        case 2:                 // Auswurf
            setPWM(0, 436);
            break;
    }
}

void setSpeed(char container, char direction)
{
    /* CW 279...322; Stop 322...331; CCW 331...374 */
    switch(direction) {
        case 0:                 // Stillstand
            setPWM(container, 326);
            break;
        case 1:                 // Rückwärts
            setPWM(container, 340);
            break;
        case 2:                 // Vorwärts
            setPWM(container, 320);
            break;
    }
}


bool controlPosition(char container)
{
    return 0;
}
int getServoAngle(char container)
{
    return 0;
}