#pragma once

/*  Define struct for time
*   @param: second -> 0 - 59
*   @param: minute -> 0 - 59
*   @param: hour -> 0 - 23
*   @param: day -> 1 - 31
*   @param: weekday -> 0 - 6 (0 = sunday)
*   @param: month -> 1 - 12
*   @param: year -> 0 - 99
*/
struct s_time {
    uint8_t second;
    uint8_t minute;
    uint8_t hour;
    uint8_t day;
    uint8_t weekday;
    uint8_t month;
    uint8_t year;
};

/*  Define struct for medication container
*   @param: container[number] -> number of tablets
*/
struct s_medContainer {
    char container[6];
};

/*  Define struct for medication
*   @param: time -> time when medication should be taken
*   @param: timeOffsetMinus -> minutes the medication can be taken before time
*   @param: timeOffsetPlus -> minutes the medication can be taken after time
*   @param: medContainer -> defined in sub structs
*/
struct s_medication {
    s_time time;
    uint8_t timeOffsetMinus;
    uint8_t timeOffsetPlus;
    s_medContainer medContainer;
};

/*  Define struct medication of one day
*   @param: defined in medication
*/
struct s_dayMed {
    s_medication moment[4];
};

/*  Define struct medication of one week
*   @param: defined in medication
*/
struct s_weekMed {
    s_dayMed day[7];
};

/*  Define struct s_user
*   @param: side -> 0 - 1 (left, right)
*   @param: firstName -> 20 char
*   @param: secondName -> 20 char
*   @param: medication -> defined in sub structs
*/
struct s_user {
    char firstName[20];
    char secondName[20];
    s_weekMed medication;
    bool valid;
};









/*  Define struct for output protocol
*   @param: user -> 0 or 1
*   @param: s_time -> current time
*   @param: medContainer -> defined in sub structs
*/
struct s_medProtocol {
    char user;
    struct s_time;
    s_medContainer medContainer;
};

/*  Define struct for inventory protocol
*   @param: s_time -> current time
*   @param: medContainer -> defined in sub structs
*/
struct s_medInventory {
    s_time currentTime;
    s_medContainer medContainer;
    char pill[6][30];
    int userNumber;
};

/*  Define struct for output error
*   @param: error -> 0 = to much pills; 1 = container is blocked; 2 = ...
*   @param: s_time -> current time
*   @param: medContainer -> defined in sub structs
*/
struct s_medError {
    char error;
    struct s_time;
    s_medContainer medContainer;
};

