#pragma once
#include "mbed.h"

void setBaud();


void Tx_interrupt();
void Rx_interrupt();


void send_line();
void read_line();

// Circular buffers for serial TX and RX data - used by interrupt routines
const int buffer_size = 1024;

// might need to increase buffer size for high baud rates
char tx_buffer[buffer_size+1];
char rx_buffer[buffer_size+1];

// Circular buffer pointers
// volatile makes read-modify-write atomic 
volatile int tx_in=0;
volatile int tx_out=0;
volatile int rx_in=0;
volatile int rx_out=0;

// Line buffers for sprintf and sscanf
char tx_line[80];
char rx_line[80];
