#pragma once
#include "SDFileSystem.h"
#include "mbed.h"
#include "variables.h"

#define STR_LEN   32
#define TOKEN ";"

void writeTest();
void readTest();
void testSd();

s_user readMedication(int user);
int writeMedication(int user,s_user userfile); 


/*  Write medication protocol to sd card
*   @param: user -> 0 or 1
*   @param: s_time medicationTime -> planned time
*   @param: s_time outputTime -> current time
*   @param: s_medContainer -> number of each pill
*   @param: success -> output=1 / no-output=0
*/
int write_medProtocol(s_time medicationTime, s_time outputTime, s_medContainer medication, int success, char user);

/*  Delete medication protocol from sd card
*/
int erase_medProtocol();

/*  Write inventory protocol to sd card / Note first read_medInventory then ajust the numbers (stock - output) and then write them back to the protocol
*   @param: s_medContainer -> number of each pill in stock
*   @param: s_time -> current time
*   @param: char med1-med6 -> name of each pill
*/
//int write_medInventory(s_medContainer medInventory, s_time currentTime, char med1[], char med2[], char med3[], char med4[], char med5[], char med6[]);
int write_medInventory(s_medInventory medInventory);

/*  Write occuring error to sd card protocol
*   @param: fail -> error string
*   @param: s_time -> current time
*/
int write_medError(char fail[], s_time time);

/*  Delete error protocol from sd card
*/
int erase_medError();

/*  Read medication protocol from sd card to a buffer
*   @param: user -> 0 or 1
*/
char *read_medProtocol(char user);

/*  Read inventory protocol from sd card to struct s_medInventory
*/
s_medInventory read_medInventory();

/*  Read error protocol from sd card to a buffer
*/
char *read_medError();

/*  Read Inventory protocol from sd card to a buffer
*/
char *read_Inventory();


char *read_Medication(char user);

