#pragma once
#include "mbed.h"

/*  Write Time for PWM
*   @ Write to global variable
*/
void writeTime();

/*  Write Period for PWM
*   @ Write to global variable
*/
void writePeriod();

/*  Disable all Container
*/
void disableContainer();

/*  Enable Container
*   @param  Container 1-6
*/
void enableContainer(char container);

/*  Get DutyCycle
*   @return DutyCycle in promille
*/
int getDutyCycle();

/*  Attach Interrupts
*/
void initInterrupt();

/*  Turn Container 90 degrees
*   @param  Container 1-6
*   @return true if next position reached
*/
int nextPosition(char container);
