#pragma once
#include "mbed.h"
#include "variables.h"

/* PWM Board */
#define ADRESS          0x40
#define MODE1           0x00
#define MODE2           0x01
#define PRESCALE        0xFE
#define LED0_ON_L       0x06
#define LED0_ON_H       0x07
#define LED0_OFF_L      0x08
#define LED0_OFF_H      0x09

#define RESTART         0x80
#define SLEEP           0x10

#define PwmOn              0x00
#define PwmOff             0x01

/*****************************************************************************/

/* RTC Board*/
#define ADRESS_RTC      0x68    
#define REG_SECOND      0x03

/*****************************************************************************/
/* PWM */

/*  Set Prescale Value and Mode
*   @param: frequency in Hz
*/
void initPWM(int8_t freq);

/*  Set PWM for each channel
*   @param: Channel 0-15
*   @param: Duty Cycle 0 - 4095
*/
void setPWM(char channel, int dutyCycle);

/*  Read current duty cycle of a channel
*   @param: Channel 0-15
*/
int getPWM(uint8_t channel);

/*  Get current prescale value
*/
int getPRESCALE(void);

/*  enable pwm board output
*/
void enableOutput(void);

/*  disables pwm board output
*/
void disableOutput(void);


/*****************************************************************************/
/* RTC */

/*  Set current time
*   @param: pointer of struct type s_time
*/
void setTime(s_time* time);

/*  Get current time
*/
s_time getTime(void);

/*  Initialize RTC
*/
void initTime(void);

/*  Convert bcd to binary
*   @param: bcd value
*/
char bcd2bin(char bcdValue);

/*  Convert binary to bcd
*   @param: binary value
*/
char bin2bcd(char binaryValue);



