#pragma once
#include "i2c.h"

/*  Set color on button
*   PWM-Channel 9-15
*   @param: button 1 or 2
*   @param: RGB Hex code eg. red 0xFF0000
*/
void setLED(char button, uint32_t color);

/*  Set valve Position
*   @param: 0 = Halten, 1 = Glas, 2 = Auswurf
*/
void setValvePosition(char pos);

/*  Set speed
*   @param Container 1-6
*   @param Direction: 0 = stop, 1 = forward, 2 = backward
*/
void setSpeed(char container, char direction);

/*  Control if Container did a quarter turn
*   @param  Container 1-6
*   @return true if next position reached
*/
bool controlPosition(char container);

/*  Calculate current Servo Angle from PWM
*   @param  Container 1-6
*   @return Angle in Degree
*/
int getServoAngle(char container);
