#pragma once
#include "mbed.h"

#include "IRSensor.h"
#define M_PI    3.14159265358979323846
#define radius  13

bool get_user();

void disable_motors();

void Robot_init_all();
void Speedcontroller_init();
void Sensor_init();

// Speed Controller
void set_speed(float left, float right);
float get_speed_left();
float get_speed_right();
void speedCtrl();

// IR Sensor
float getDistanceIR(int number);
void SensorTicker();

//Color sensor
bool get_color();   //1 if green, 0 if red or error

// IMU
float read_acc_x();
float read_acc_y();
float read_acc_z();
float read_gyr_x();
float read_gyr_y();
float read_gyr_z();
float read_heading();

// I2C
void init_servo(int freq);
void set_servo_position(int servo, int deg);
int getPWM(uint8_t servo);
int getPRESCALE(void);

void enable_servos();
void disable_servos();