#include "mbed.h"

#ifndef ROTARY_ENCODER_H_
#define ROTARY_ENCODER_H_

/**
 Rotary encoder handling class.
 Starts a ticker which checks the status of the encoder and
 sets the rotation directions based on its status.
*/
class RotaryEncoder {
public:
    RotaryEncoder(void (*cb)(void), PinName channelA_, PinName channelB_, PinName pushPin_, float period = 0.01);
    virtual ~RotaryEncoder();
    
    /// Retrieve rotation direction.
    int8_t getDirection() const;
    /// Retrieve push button status.
    bool getPushButton() const;
    /// Launched by Ticker to determine rotation direction
    void pulse();
    
    int getCounter() const;
    
    private:
    
    /// Table which helps determine the rotation direction
    static const int8_t encoderTable[];

    int counter;
    int8_t direction;
    int8_t lastDirection;
    InterruptIn channelA;
    InterruptIn channelB;
    InterruptIn pushPin;
    Ticker encoderTicker;
    
};

#endif /* ROTARY_ENCODER_H_ */