#include "RotaryEncoder.h"

RotaryEncoder::RotaryEncoder(void (*cb)(void), PinName channelA_, PinName channelB_, PinName pushPin_, float period)
 : channelA(channelA_), channelB(channelB_), pushPin(pushPin_)
{
    direction = 0;
    counter = 0;
    lastDirection = 0;

    encoderTicker.attach(this, &RotaryEncoder::pulse, period);
    pushPin.rise(cb);
}

RotaryEncoder::~RotaryEncoder() {};

/** Public methods **/

int8_t RotaryEncoder::getDirection() const
{
    return direction;   
}

int RotaryEncoder::getCounter() const
{
    return counter;
}

bool RotaryEncoder::getPushButton() const
{
    return false;   
}

/** Private methods **/

void RotaryEncoder::pulse()
{    
    lastDirection <<= 2;
    if (channelB) lastDirection |= 1;
    if (channelA) lastDirection |= 2;
    
    direction = encoderTable[lastDirection & 0x0F];
    counter += direction;
}

const int8_t RotaryEncoder::encoderTable[] = {0, 0, 0, 0, 1, 0, 0, -1, -1, 0, 0, 1, 0, 0, 0, 0};