#include "QEI.h"

Serial pc(USBTX, USBRX);
RawSerial smc(PC_6, PA_12);
//Use X2 encoding by default.
QEI wheel (PC_8, PC_5, NC, 624);

Ticker ctrl_tick;

int tgt = 5000;

void ctrl_event() {
    static int rot = 0;
    static int output = 0;
    rot = wheel.getPulses();
    pc.printf("Pulses is: %i\n\r", rot);
    int err = tgt - rot;
    if (err > 0) {
        err = err;
        output = (err * 0.1);
        if (output > 127) output = 127;
        smc.putc(0x8A);
        smc.putc((uint8_t)output);
    } else {
        err =  -err;
        output = (err * 0.1);
        if (output > 127) output = 127;
        smc.putc(0x89);
        smc.putc(output);
    }
}
 
int main() {
    pc.baud(115200);
    smc.baud(115200);
    ctrl_tick.attach(&ctrl_event, 0.1);
    while(1){
        wait(5);
        if (tgt != 0) tgt = 0;
        else tgt = 5000;
    }
}