#include "Widget.h"

void AbstractWidget::redraw()
{
    //if state has changed in this widget
    if(state_changed) {
        paint();
        pc.printf("starting to paint# \r\n");
        state_changed = false;
    }
    //redraw action for all children
    for(vector<AbstractWidget*>::iterator it = children.begin(); it != children.end(); it++) {
        AbstractWidget* w = *it;
        w->redraw();
    }
}

void AbstractWidget::refresh()
{
    state_changed = true;
    //try to re-adjust cordinates for any children of 'p'
    if(children.size() > 0 ) {
        curr_row = 0 ;
        curr_col = 0 ;
        for(vector<AbstractWidget*>::iterator it = children.begin(); it != children.end(); it++) {
            AbstractWidget* pnl = (*it);
            push_children = false ;
            addWidget(pnl);
            push_children = true ;
        }
    }
    //refresh action for all children
    for(vector<AbstractWidget*>::iterator it = children.begin(); it != children.end(); it++) {
        AbstractWidget* w = *it;
        w->refresh();
    }
}

AbstractWidget* AbstractWidget::remove_child()
{
    AbstractWidget* w = children.back();
    children.pop_back();
    //refresh state of returned widget
//        w->refresh();
    //revert to previous row/col position
    curr_row = prev_row;
    curr_col = prev_col;
    return w;
}

void AbstractWidget::trigger_action(ActionType type, ActionEvent evnt, void* target)
{
    //do nothing
}


void AbstractWidget::inject_action(int x, int y)
{
    double di_per_pixel = 28.9583;
    double dj_per_pixel = 21.25;

    int x_cord = x / di_per_pixel ;
    int y_cord = y / dj_per_pixel ;
    //do nothing
    ActionEvent evnt;
    ActionType type;
    evnt.x = x_cord;
    evnt.y = y_cord ;
    type = CORD;
    //do this action if registered for events and is inside the input window
    if(x_cord > x0 && x_cord < x1 && y_cord > y0 && y_cord < y1 ) {
        action(type, evnt);
    }
    //also inject for children
    for(vector<AbstractWidget*>::iterator it = children.begin(); it != children.end(); it++) {
        AbstractWidget* w = *it;
        w->inject_action(x, y);
    }
}
