#pragma once
#include "mbed.h"
#include "SeeedStudioTFTv2.h"
#include "ActionListener.h"
#include <vector>
//extern ActionType;

extern SeeedStudioTFTv2 TFT;
extern Serial pc;
//class ActionEvent;
//class ActionListener;
//typedef enum { CORD, STR, CORD_STR } ActionType;

class AbstractWidget:public ActionListener
{
    friend class Panel;
public:
    void redraw();

    //refresh state of this widget and all its children
    void refresh() ;

    AbstractWidget* remove_child();
    
    virtual void trigger_action(ActionType type, ActionEvent evnt, void* target);
    
    void inject_action(int x, int y);


protected:
    virtual bool addWidget(AbstractWidget *p){return true;};
    vector<AbstractWidget*> children;
    bool state_changed ;
    virtual void paint()=0;
    int back_color, border_color;
    //relative measure unit on space occupied on parent
    //width/hieght in "cell" units
    int width, height ;
    //left top corner of widget
    int x0,y0 ;
    //right bottom corner of widget
    int x1,y1 ;
    //number of cells panel is divided into
    //book keeping for child widgets
    int rows, cols ;
    double pp_row;
    double pp_col;
    bool push_children;  

    int curr_row;
    int curr_col;
    int prev_row;
    int prev_col;

};