#include "Button.h"
#include "Arial24x23.h"
#include "Arial12x12.h"

Button::Button(char* label, int p_color, int bd_color):Panel(p_color, bd_color, 1, 1, 1 , 1){
    lbl = label;        
}

Button::Button(char* label, int p_color, int bd_color,  int w, int h):Panel(p_color, bd_color, w, h, 1 , 1){
    lbl = label;        
}

void Button::paint(){
    Panel::paint();
    TFT.background(DarkGrey);
    TFT.foreground(Black);
    TFT.set_font((unsigned char*) Arial12x12);
    TFT.locate(x0+8,y0+12);
    TFT.printf(lbl);
}

void Button::trigger_action(ActionType type, ActionEvent evnt, void* target){
        //do something  
        if(type == CORD){
            ActionEvent new_event;
            new_event.x = evnt.x;       
            new_event.y = evnt.y; 
            new_event.str = lbl; 
            ActionType type;
            type = CORD_STR;
            
            Panel* target_pnl = (Panel*) target;
            target_pnl->trigger_action(type, new_event, NULL);
        }
}