#include "Panel.h"
#include "Arial12x12.h"

Panel::Panel(int x_0, int y_0, int x_1, int y_1, int p_color, int bd_color, int r = 1, int c = 1)
{
    x0 = x_0;
    y0 = y_0;
    x1 = x_1;
    y1 = y_1 ;
    init(p_color, bd_color, r, c);
    //calculate pixels per row/col
    pp_row = TFT.height() / (rows+0.0) ;
    pp_col = TFT.width() / (cols+0.0) ;
    redraw();
}

Panel::Panel(int p_color, int bd_color, int w, int h, int r, int c)
{
    x0 = -1;
    y0 = -1;
    x1 = -1;
    y1 = -1 ;
    init(p_color, bd_color, r, c);

    //space on parent
    width = w ;
    height = h ;
    //don't redraw we want to programatically do the drawing and change state
//    redraw();
}

void Panel::init(int p_color, int bd_color, int r, int c)
{
    back_color = p_color;
    border_color = bd_color;
    rows = r ;
    cols = c ;

    curr_row = 0;
    curr_col = 0;

    //state info
    state_changed = true ;
    push_children = true ;
    draw_text = false;
    cursor_x0 = x0;
    cursor_y0 = y0 ;
    next_cursor_x0 = cursor_x0 ;
    next_cursor_y0 = cursor_y0;
}

void Panel::paint()
{
    TFT.rect(x0,y0,x1,y1,border_color);
    //paint fill
    TFT.fillrect(x0+2,y0+2,x1-2,y1-2,back_color);
    if(draw_text) {
        TFT.set_font((unsigned char*) Arial12x12);
        TFT.locate(cursor_x0 ,cursor_y0);
        TFT.printf(input_string);
        draw_text = false;
    }
}

bool Panel::addWidget(AbstractWidget *p)
{
    //include as a child
    if(push_children) {
        children.push_back(p);
    }

    //adjust pixels per row/col values for panel 'p'
    //this is [number of pixels taken by p] / [row or col divisions]
    p->pp_row = (pp_row*p->height)/p->rows;
    p->pp_col = (pp_col*p->width)/p->cols;
    //re-adjust absolute cordinates of Panel 'p'
    //get parents x,y locations and curr row, col numbers to calculate new location
    //also update next available row/col

    while(curr_row < rows && curr_col < cols) {
        int rows_to_bottom = rows - curr_row  ;
        int cols_to_right = cols - curr_col ;

        if(cols_to_right >= p->width) {
            //we are good to fit widget to the right
            //now check if rows would fit widget
            if(rows_to_bottom >= p->height) {
                //ok all is good
                //update x,y for this widget
                p->x0 = x0 + pp_col*curr_col ;
                p->y0 = y0 + pp_row*curr_row ;
                p->x1 = p->x0 + pp_col*p->width;
                if(p->x1 + pp_col*1 > x1) {
                    //lookahead if the panel that is added now is in the last coloumn adjust it x corner to boundary
                    p->x1 = x1;
                }
                p->y1 = p->y0 + pp_row*p->height;
                if(p->y1 + pp_row*1 > y1) {
                    //if the panel that is added is in the last row then adjust its x corner to boundary
                    p->y1 = y1;
                }
                //keep previous row,col for updates to this widget
                prev_col = curr_col;
                prev_row = curr_row;
                //set next col
                if ((curr_col + p->width) >= cols) {
                    curr_col = 0 ;
                } else {
                    curr_col = (curr_col + p->width);
                } ;
                if(curr_col == 0) {
                    curr_row = curr_row + p->height ;
                } else {
                    curr_row = curr_row + p->height - 1 ;
                }
                //printf("next row: %d next col: %d \n", curr_row, curr_col);
                break;
            } else {
                //not going to fit with a sweep algorithm
                return false;
            }
        } else {
            //go to the next row and col 0 and start again
            curr_row += 1 ;
            curr_col = 0 ;
        }
    }

    pc.printf("c_row: %d c_col: %d --- child x0,y0 : %d,%d  x1,y1 : %d,%d --- pp_row, pp_col : %f,%f \r\n", curr_row, curr_col,
              p->x0,p->y0,p->x1,p->y1,p->pp_row ,p->pp_col);

    return true;

}

void Panel::trigger_action(ActionType type, ActionEvent evnt, void* target)
{
    //do something
    if(type == CORD_STR) {
        char* input_str = evnt.str;
        int len = strlen(input_str);

        int x_pixels = len*12;
        cursor_x0 = next_cursor_x0 ;
        cursor_y0 = next_cursor_y0 ;

        if(cursor_x0 < 240 && cursor_y0 < 320 ) {
            if(cursor_x0 + x_pixels >= 240) {
                next_cursor_y0 = cursor_y0 + 14;
                next_cursor_x0 = x0 ;
            } else {
                next_cursor_x0 = (cursor_x0 + x_pixels);
            }
            input_string = input_str;
            draw_text = true;
            state_changed = true;
        }

    }
}
