/*
  main.cpp
  2014 Copyright (c) Seeed Technology Inc.  All right reserved.

  Author:lawliet zou(lawliet.zou@gmail.com)
  2014-02-17

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "mbed.h"
#include "SeeedStudioTFTv2.h"
#include "Arial12x12.h"
#include "Arial24x23.h"
#include "Arial28x28.h"
#include "font_big.h"
#include "Panel.h"
#include "Button.h"

#define PIN_XP          A3
#define PIN_XM          A1
#define PIN_YP          A2
#define PIN_YM          A0
#define PIN_MOSI        D11
#define PIN_MISO        D12
#define PIN_SCLK        D13
#define PIN_CS_TFT      D5
#define PIN_DC_TFT      D6
#define PIN_BL_TFT      D7
#define PIN_CS_SD       D4

SeeedStudioTFTv2 TFT(PIN_XP, PIN_XM, PIN_YP, PIN_YM, PIN_MOSI, PIN_MISO, PIN_SCLK, PIN_CS_TFT, PIN_DC_TFT, PIN_BL_TFT, PIN_CS_SD);
Serial pc(USBTX, USBRX);

int main()
{
    //Configure the display driver
//    TFT.background(Black);
//    TFT.foreground(White);
//    TFT.cls();
//
//    //Print a welcome message
//    TFT.set_font((unsigned char*) Arial12x12);
//    TFT.locate(0,0);
//    TFT.printf("Hello Mbed");
//
//    //Wait for 5 seconds
//    wait(5.0);
//
//    //Draw some graphics
//    TFT.cls();
//    TFT.set_font((unsigned char*) Arial24x23);
//    TFT.locate(100,100);
//    TFT.printf("Graphic");
//
//    TFT.line(0,0,100,0,Green);
//    TFT.line(0,0,0,200,Green);
//    TFT.line(0,0,100,200,Green);
//
//    TFT.rect(100,50,150,100,Red);
//    TFT.fillrect(180,25,220,70,Blue);
//
//    TFT.circle(80,150,33,White);
//    TFT.fillcircle(160,190,20,Yellow);
//
//    double s;
//    for (int i = 0; i < 320; i++) {
//        s = 20 * sin((long double)i / 10);
//        TFT.pixel(i, 100 + (int)s, Red);
//    }
//
//    //Wait for 5 seconds
////    wait(5.0);
//
//    //Multiple fonts
//    //TFT.foreground(White);
////    TFT.background(Blue);
////    TFT.cls();
////    TFT.set_font((unsigned char*) Arial24x23);
////    TFT.locate(0,0);
////    TFT.printf("Different Fonts:");
////    TFT.set_font((unsigned char*) Neu42x35);
////    TFT.locate(0,30);
////    TFT.printf("Hello Mbed 1");
////    TFT.set_font((unsigned char*) Arial24x23);
////    TFT.locate(20,80);
////    TFT.printf("Hello Mbed 2");
////    TFT.set_font((unsigned char*) Arial12x12);
////    TFT.locate(35,120);
//
//    //Wait for 5 seconds
//    wait(1.0);

    //Configure the display driver
    TFT.background(Black);
    TFT.foreground(White);
    TFT.cls();
//    TFT.set_font((unsigned char*) Arial24x23);
//    TFT.locate(0,0);
//    TFT.printf("Calibrating...");

    wait(1.0);
    
    pc.printf("START..... \r\n");
    
    Panel window(0, 0, 240, 320, Navy, Black, 3, 1);
    Panel textDisplay(White, Black, 1, 1, 2, 2);
    
    //create Key Panel
    //Panel( back_color,  border_color, w, h, rows, cols); 
    Panel keyPanel(Black, Black, 1, 2, 5, 10);
    
    //create first row keys
    Button Key_Q("W",DarkGrey,White);
    Button Key_W("Q",DarkGrey,White);
    Button Key_E("E",DarkGrey,White);
    Button Key_R("R",DarkGrey,White);
    Button Key_T("T",DarkGrey,White);
    Button Key_Y("Y",DarkGrey,White);
    Button Key_U("U",DarkGrey,White);
    Button Key_I("I",DarkGrey,White);
    Button Key_O("O",DarkGrey,White);
    Button Key_P("P",DarkGrey,White);
    
    //second row keys
    Button Key_A("A",DarkGrey,White);
    Button Key_S("S",DarkGrey,White);
    Button Key_D("D",DarkGrey,White);
    Button Key_F("F",DarkGrey,White);
    Button Key_G("G",DarkGrey,White);
    Button Key_H("H",DarkGrey,White);
    Button Key_J("J",DarkGrey,White);
    Button Key_K("K",DarkGrey,White);
    Button Key_L("L",DarkGrey,White);
    Button Key_COMMA(",",DarkGrey,White);
    
     //third row keys
    Button Key_SHIFT("s^",DarkGrey,White);
    Button Key_Z("Z",DarkGrey,White);
    Button Key_X("X",DarkGrey,White);
    Button Key_C("C",DarkGrey,White);
    Button Key_V("V",DarkGrey,White);
    Button Key_B("B",DarkGrey,White);
    Button Key_N("N",DarkGrey,White);
    Button Key_M("M",DarkGrey,White);
    Button Key_BKSPACE("<-",DarkGrey,White);
    Button Key_DOT(".",DarkGrey,White);
    
    //fourth row keys
    Button Key_SEND("SEND",DarkGrey,White,3,1);
    Button Key_SPACE("  SPACE",DarkGrey,White,4,1);
    Button Key_NEWLINE("n^",DarkGrey,White,1,1);
    Button Key_CALL_MENU("CALL",DarkGrey,White,2,1);
    
    window.addWidget(&textDisplay);
    window.addWidget(&keyPanel);
    
    keyPanel.addWidget(&Key_Q);
    keyPanel.addWidget(&Key_W);
    keyPanel.addWidget(&Key_E);
    keyPanel.addWidget(&Key_R);
    keyPanel.addWidget(&Key_T);
    keyPanel.addWidget(&Key_Y);
    keyPanel.addWidget(&Key_U);
    keyPanel.addWidget(&Key_I);
    keyPanel.addWidget(&Key_O);
    keyPanel.addWidget(&Key_P);
    //
    keyPanel.addWidget(&Key_A);
    keyPanel.addWidget(&Key_S);
    keyPanel.addWidget(&Key_D);
    keyPanel.addWidget(&Key_F);
    keyPanel.addWidget(&Key_G);
    keyPanel.addWidget(&Key_H);
    keyPanel.addWidget(&Key_J);
    keyPanel.addWidget(&Key_K);
    keyPanel.addWidget(&Key_L);
    keyPanel.addWidget(&Key_COMMA);
    //
    keyPanel.addWidget(&Key_SHIFT);
    keyPanel.addWidget(&Key_Z);
    keyPanel.addWidget(&Key_X);
    keyPanel.addWidget(&Key_C);
    keyPanel.addWidget(&Key_V);
    keyPanel.addWidget(&Key_B);
    keyPanel.addWidget(&Key_N);
    keyPanel.addWidget(&Key_M);
    keyPanel.addWidget(&Key_BKSPACE);
    keyPanel.addWidget(&Key_DOT);
    //
    keyPanel.addWidget(&Key_SEND);
    keyPanel.addWidget(&Key_SPACE);
    keyPanel.addWidget(&Key_NEWLINE);
    keyPanel.addWidget(&Key_CALL_MENU);
    
    //DIAL Pad
    Panel dialPanel(Black, Black, 1, 2, 4, 3);
    Button Key_1("1",DarkGrey,White);
    Key_1.registerForEvents(&textDisplay);
    Button Key_2("2",DarkGrey,White);
    Button Key_3("3",DarkGrey,White);
    
    Button Key_4("4",DarkGrey,White);
    Button Key_5("5",DarkGrey,White);
    Button Key_6("6",DarkGrey,White);
    
    Button Key_7("7",DarkGrey,White);
    Button Key_8("8",DarkGrey,White);
    Button Key_9("9",DarkGrey,White);
    
    Button Key_CALL("CALL",DarkGrey,White);
    Button Key_0("0",DarkGrey,White);
    Button Key_SMS("SMS",DarkGrey,White);
    
    dialPanel.addWidget(&Key_1);
    dialPanel.addWidget(&Key_2);
    dialPanel.addWidget(&Key_3);
    dialPanel.addWidget(&Key_4);
    dialPanel.addWidget(&Key_5);
    dialPanel.addWidget(&Key_6);
    dialPanel.addWidget(&Key_7);
    dialPanel.addWidget(&Key_8);
    dialPanel.addWidget(&Key_9);
    dialPanel.addWidget(&Key_CALL);
    dialPanel.addWidget(&Key_0);
    dialPanel.addWidget(&Key_SMS);
    
    pc.printf("LOOP..... \r\n");
    wait(2);
    
//    TFT.calibrate();
    point p ;
    while(true) {
        
        TFT.getPixel(p);
        window.redraw();
        
        window.remove_child();
        window.addWidget(&dialPanel);
        window.refresh();
        window.redraw();
        
        wait(2);
        
        window.remove_child();
        window.addWidget(&keyPanel);
        window.refresh();
        window.redraw();
        wait(2);
        

    }

}
