#pragma once
#include <vector>
#include "mbed.h"

typedef enum { CORD, STR, CORD_STR } ActionType;

class ActionEvent{
public:
    //pixel x that event took place
    int x;  
    //pixel y that event took place
    int y;   
    
    char* str;
};

class ActionListener{
public:
    ActionListener();
    
    void registerForEvents(ActionListener* widg);
    
    void action(ActionType type, ActionEvent evnt);

protected:
    virtual void trigger_action( ActionType type, ActionEvent evnt, void* target)=0;
    bool is_reg;
    
private:
    ActionListener* target; 
       
};