#pragma once
#include "mbed.h"
#include "Command.h"
#include <vector>
extern Serial pc;

using namespace std;

class SerialConsole
{
    const char* prompt_str;
    char buffer[100];
    int param;
    
    //command list
    vector<Cmd*> cmds;
    //available commands
    Led_On_Cmd cmd1;
    Led_Off_Cmd cmd2;
    Help_cmd cmd3;
    Cmd null_cmd;

public:
    SerialConsole();
    SerialConsole(char* pr) ;
    void start() ;
    void newline() ;
    
private:
    void init() ;
    Cmd* parse_command(int count);
    void prompt();
    

    /*   STARTUP MESSAGE
    ************************************************
    *************Simple LED Console*****************
    ************************************************
    *A Console Application to manage LED Digital****
    *ouput for ARM cortex M4 - LPC1768, covered by**
    *Apache General Public License  ****************
    ************************************************
    ***Author : U.S. Wickramasinghe*****************
    ***Corperation : Indiana University*************
    *Please email uswickra@umail.iu.edu for source**
    ************************************************
    */
    void print_startup_msg() ;
    

};
