#include "SerialConsole.h"

SerialConsole::SerialConsole()
{
    prompt_str = "p542% ";
    init();
}

SerialConsole::SerialConsole(char* pr)
{
    prompt_str = pr;
    init();
}

void SerialConsole::start()
{
    //start with prompt
    print_startup_msg();
    prompt();
    //
    int count = 0 ;
    while(1) {
        char ch = pc.getc();
        if (ch == 0x08 || ch == 0x7F ){
            if(count > 0) {
                pc.putc(8);
                pc.putc(32);
                pc.putc(8);
                count--;
            }
            continue;    
        }
        buffer[count++] = ch ;
        //check for carriage return or new line
        if(ch == 0x0a || ch == 0x0d ) {
            //for each new line parse command then execute command
            Cmd* in_cmd = parse_command(count);
            in_cmd->execute(param);
            //reset count/buffer
            count = 0;
            //go to a new command line
            newline();
            prompt();
            continue ;
        } else if (ch == 'q') {
            //exit
            newline();
            prompt();
            return;
        }
        pc.putc(ch);
    }
}

void SerialConsole::init()
{
    //default param
    param = 1 ;
    //default commands
    cmds.push_back(&cmd1);
    cmds.push_back(&cmd2);
    cmds.push_back(&cmd3);
}

Cmd* SerialConsole::parse_command(int count)
{
    //parse command from buffer
    int curr_pos = 0;
    //loop until a space is encounterred
    //discard any leading spaces
    bool check_leading_spaces = true;
    bool check_cmd_str = true;
    bool check_arg_str = false;
    char cmd_str[100];
    char arg_str[100];
    int cmd_str_idx = 0;
    int arg_str_idx = 0;
    while (curr_pos < count) {
        if(buffer[curr_pos] == '\0') {
            break;
        }
        if (check_leading_spaces && buffer[curr_pos] == ' ') {
            curr_pos++;
            continue;
        } else if (check_cmd_str && buffer[curr_pos] != ' ') {
            //we have come to the command string start
            check_leading_spaces = false;
            cmd_str[cmd_str_idx++] = buffer[curr_pos];
        } else if (check_arg_str && buffer[curr_pos] != ' ') {
            //we have come to the arg string start
            check_leading_spaces = false;
            arg_str[arg_str_idx++] = buffer[curr_pos];
        } else if (buffer[curr_pos] == ' ') {
            if(check_arg_str) break;
            // we have come to the spaces after cmd string
            check_cmd_str = false;
            check_leading_spaces = true;
            check_arg_str = true;
        }
        curr_pos++;
    };

    //make valid C string for comparison
    cmd_str[cmd_str_idx]= '\0';
    arg_str[arg_str_idx]= '\0';

    //find any command matching input
    for(vector<Cmd*>::iterator it = cmds.begin(); it != cmds.end(); it++) {
        Cmd* curr_cmd = *it;
        if(strcmp(curr_cmd->get_name(), cmd_str) == 0) {
            //success : command found for given input
            param = atoi(arg_str);
            //todo remove
//            newline();
//            pc.puts("CMD SUCCESS  param : ");
//            pc.printf("%d", param);
//            newline();
            return curr_cmd;
        }
    }
    return &null_cmd;
}

void SerialConsole::prompt()
{
    pc.puts(prompt_str);
}

void SerialConsole::newline()
{
    pc.putc(0x0d);
    pc.putc(0x0a);
}

void SerialConsole::print_startup_msg()
{
    newline();
    pc.puts("************************************************");
    newline();
    pc.puts("*****         Simple LED Console          ******");
    newline();
    pc.puts("************************************************");
    newline();
    pc.puts("* A Console Application to manage LED Digital  *");
    newline();
    pc.puts("* ouput for ARM cortex M4 - LPC1768, covered by*");
    newline();
    pc.puts("* Apache General Public License                *");
    newline();
    pc.puts("************************************************");
    newline();
    pc.puts("* Author : U.S. Wickramasinghe                 *");
    newline();
    pc.puts("* Corporation : Indiana University             *");
    newline();
    pc.puts("* Please email uswickra@umail.iu.edu for source*");
    newline();
    pc.puts("*                                              *");
    newline();
    pc.puts("************************************************");
    newline();
    pc.puts("* type 'help 1' for available usage.           *");
    newline();
    pc.puts("************************************************");
    newline();
    newline();

};

