#pragma once
extern Serial pc;

extern DigitalOut led1;
extern DigitalOut led2;
extern DigitalOut led3;
extern DigitalOut led4;

class Cmd
{
protected:
    char* cmd_name;
    void newline(){
         pc.putc(0x0d);
         pc.putc(0x0a);    
    }

public:
    virtual void execute(int arg_val) {
        newline();
        pc.puts("ERR");
    }

    char* get_name() {
        return cmd_name;
    };
};

class Led_On_Cmd: public Cmd
{
public:
    Led_On_Cmd() {
        cmd_name = "LON";
    }

    void execute(int arg_val) {
        newline();
        
        if(arg_val == 1) {
            led1 = 1;
            pc.puts("OK");
        } else if (arg_val == 2) {
            led2 = 1;
            pc.puts("OK");
        } else if (arg_val == 3) {
            led3 = 1;
            pc.puts("OK");
        } else if (arg_val == 4) {
            led4 = 1;
            pc.puts("OK");
        }
    }
};

class Led_Off_Cmd: public Cmd
{
public:
    Led_Off_Cmd() {
        cmd_name = "LOF";
    }

    void execute(int arg_val) {
        newline();
        
        if(arg_val == 1) {
            led1 = 0;
            pc.puts("OK");
        } else if (arg_val == 2) {
            led2 = 0;
            pc.puts("OK");
        } else if (arg_val == 3) {
            led3 = 0;
            pc.puts("OK");
        } else if (arg_val == 4) {
            led4 = 0;
            pc.puts("OK");
        }
    }
};


class Help_cmd: public Cmd
{
public:
    Help_cmd() {
        cmd_name = "help";
    }

    void execute(int arg_val) {
        newline();
        pc.puts("Usage : ");
        newline();
        pc.puts("LON <led_num>   :  Turn on led indicated by <led_num>");
        newline();
        pc.puts("LOF <led_num>   :  Turn off led indicated by <led_num>");
        newline();
        pc.puts("q               :  Exit program");
    }
};
