#pragma once
#include "mbed.h"
#include "SeeedStudioTFTv2.h"

extern SeeedStudioTFTv2 TFT;
//extern Serial pc;
enum GSM_MESSAGE {
    MESSAGE_NONE = 0 ,
    MESSAGE_RING = 1,
    MESSAGE_SMS  = 2,
    MESSAGE_ERROR
};

#define BUF_SIZE 100
#define SMS_MAX_LENGTH          300
class Modem{

public:
    Modem(PinName tx, PinName rx, int baudRate,char *default_number);
    int init();
    int call_phone(char* number);
    void recv_phone();
    void hangup_phone();
    int send_sms(char* number, char* msg);
    void recv_sms(char* msg, int msg_size,  int index);
    void get_clck(char* msg, int size);
    void cls();
    Serial serial_modem;
    Timer timeCnt;
    int loopHandle(void);
    char messageBuffer[SMS_MAX_LENGTH];
    char messageCopyBuffer[SMS_MAX_LENGTH];
    int updateBuffer(char c);
    void copy_msg();
    int mIndex ;
    int mTypeState ;

protected:
    int sendCmdWaitResp(char* cmd, char* response, int timeout);    
    int write_device(char c);
    int write_device_str(char* str);
    bool read_device_ready();
    char read_device();
    
    int check_AT();
    int check_PIN();
    int setup_SMS();
    
    char read_buffer[BUF_SIZE+1];
    int buffer_p;
    void clean_buffer();
    void reset_buffer();

    
private:
    
    char* default_number;
    bool read_trail;
    void debug_cmd_buffer();
    int find_pattern_end(char *pattern, char *buffer, int size);
    
    
};