#include "mbed.h"
#include "MPL3115A2.h"
#include "string"
#include "ctype.h"

Serial pc(SERIAL_TX, SERIAL_RX);
DigitalOut myled(LED1);

// Selects SDA as I2C1_SDA on pin PB_7
// Selects SCL on I2C1_SCL on pin PB_6
// The I2C address of the pressure sensor is fixed at 0x60. 
MPL3115A2 pressure_sensor(PB_7,PB_6,0x60);

struct dataPoints
{
   double pres;
   double alt;
   
};

int mpl3115_reg_print(int start, int length) {

    if(0x00 <= start && start <=0x2D){
        if(length==0){
            length=46;
            uint8_t data[1];
            for(int i=start; i<length; i++){
                pressure_sensor.readRegs(i, data, 1); 
                switch(i){
                    case(0x00):
                        printf("0x%x: MPL_STATUS=0x%x\r\n",i,data[0]);
                        break;
                    case(0x01):
                        printf("0x%x: MPL_OUT_P_MSB=0x%x\r\n",i,data[0]);
                        break;
                    case(0x02):
                        printf("0x%x: MPL_OUT_P_CSB=0x%x\r\n",i,data[0]);
                        break;
                    case(0x03):
                        printf("0x%x: MPL_OUT_P_LSB=0x%x\r\n",i,data[0]);
                        break;
                    case(0x04):
                        printf("0x%x: MPL_OUT_T_MSB=0x%x\r\n",i,data[0]);
                        break;
                    case(0x05):
                        printf("0x%x: MPL_OUT_T_LSB=0x%x\r\n",i,data[0]);
                        break;
                    case(0x06):
                        printf("0x%x: MPL_DR_STATUS=0x%x\r\n",i,data[0]);
                        break;
                    case(0x07):
                        printf("0x%x: MPL_OUT_P_DELTA_MSB=0x%x\r\n",i,data[0]);
                        break;
                    case(0x08):
                        printf("0x%x: MPL_OUT_P_DELTA_CSB=0x%x\r\n",i,data[0]);
                        break;
                    case(0x09):
                        printf("0x%x: MPL_OUT_P_DELTA_LSB=0x%x\r\n",i,data[0]);
                        break;
                    case(0x0A):
                        printf("0x%x: MPL_OUT_T_DELTA_MSB=0x%x\r\n",i,data[0]);
                        break;
                    case(0x0B):
                        printf("0x%x: MPL_OUT_T_DELTA_LSB=0x%x\r\n",i,data[0]);
                        break;
                    case(0x0C):
                        printf("0x%x: MPL_WHO_AM_I=0x%x\r\n",i,data[0]);
                        break;
                    case(0x0D):
                        printf("0x%x: MPL_F_STATUS=0x%x\r\n",i,data[0]);
                        break;
                    case(0x0E):
                        printf("0x%x: MPL_F_DATA=0x%x\r\n",i,data[0]);
                        break;
                    case(0x0F):
                        printf("0x%x: MPL_F_SETUP=0x%x\r\n",i,data[0]);
                        break;
                    case(0x10):
                        printf("0x%x: MPL_TIME_DLY=0x%x\r\n",i,data[0]);
                        break;
                    case(0x11):
                        printf("0x%x: MPL_SYSMOD=0x%x\r\n",i,data[0]);
                        break;
                    case(0x12):
                        printf("0x%x: MPL_INT_SOURCE=0x%x\r\n",i,data[0]);
                        break;
                    case(0x13):
                        printf("0x%x: MPL_PT_DATA_CFG=0x%x\r\n",i,data[0]);
                        break;
                    case(0x14):
                        printf("0x%x: MPL_BAR_IN_MSB=0x%x\r\n",i,data[0]);
                        break;
                    case(0x15):
                        printf("0x%x: MPL_BAR_IN_LSB=0x%x\r\n",i,data[0]);
                        break;
                    case(0x16):
                        printf("0x%x: MPL_P_TGT_MSB=0x%x\r\n",i,data[0]);
                        break;
                    case(0x17):
                        printf("0x%x: MPL_P_TGT_LSB=0x%x\r\n",i,data[0]);
                        break;
                    case(0x18):
                        printf("0x%x: MPL_T_TGT=0x%x\r\n",i,data[0]);
                        break;
                    case(0x19):
                        printf("0x%x: MPL_P_WND_MSB=0x%x\r\n",i,data[0]);
                        break;
                    case(0x1A):
                        printf("0x%x: MPL_P_WND_LSB=0x%x\r\n",i,data[0]);
                        break;
                    case(0x1B):
                        printf("0x%x: MPL_T_WND=0x%x\r\n",i,data[0]);
                        break;
                    case(0x1C):
                        printf("0x%x: MPL_P_MIN_MSB=0x%x\r\n",i,data[0]);
                        break;        
                    case(0x1D):
                        printf("0x%x: MPL_P_MIN_CSB=0x%x\r\n",i,data[0]);
                        break;
                    case(0x1E):
                        printf("0x%x: MPL_P_MIN_LSB=0x%x\r\n",i,data[0]);
                        break;
                    case(0x1F):
                        printf("0x%x: MPL_T_MIN_MSB=0x%x\r\n",i,data[0]);
                        break;
                    case(0x20):
                        printf("0x%x: MPL_T_MIN_LSB=0x%x\r\n",i,data[0]);
                        break;
                    case(0x21):
                        printf("0x%x: MPL_P_MAX_MSB=0x%x\r\n",i,data[0]);
                        break;
                    case(0x22):
                        printf("0x%x: MPL_P_MAX_CSB=0x%x\r\n",i,data[0]);
                        break;
                    case(0x23):
                        printf("0x%x: MPL_P_MAX_LSB=0x%x\r\n",i,data[0]);
                        break;
                    case(0x24):
                        printf("0x%x: MPL_T_MAX_MSB=0x%x\r\n",i,data[0]);
                        break;
                    case(0x25):
                        printf("0x%x: MPL_T_MAX_LSB=0x%x\r\n",i,data[0]);
                        break;
                    case(0x26):
                        printf("0x%x: MPL_CTRL_REG1=0x%x\r\n",i,data[0]);
                        break;
                    case(0x27):
                        printf("0x%x: MPL_CTRL_REG2=0x%x\r\n",i,data[0]);
                        break;
                    case(0x28):
                        printf("0x%x: MPL_CTRL_REG3=0x%x\r\n",i,data[0]);
                        break;
                    case(0x29):
                        printf("0x%x: MPL_CTRL_REG4=0x%x\r\n",i,data[0]);
                        break;
                    case(0x2A):
                        printf("0x%x: MPL_CTRL_REG5=0x%x\r\n",i,data[0]);
                        break;
                    case(0x2B):
                        printf("0x%x: MPL_OFF_P=0x%x\r\n",i,data[0]);
                        break;
                    case(0x2C):
                        printf("0x%x: MPL_OFF_T=0x%x\r\n",i,data[0]);
                        break;
                    case(0x2D):
                        printf("0x%x: MPL_OFF_H=0x%x\r\n",i,data[0]);
                        break;
                    case(0x2E):
                        printf("0x%x: MPL_T_MIN_MSB=0x%x\r\n",i,data[0]);
                        break;
                    case(0x2F):
                        printf("0x%x: MPL_T_MIN_MSB=0x%x\r\n",i,data[0]);
                        break;
                }
            }
        }
        else if(length>0){
        uint8_t data[1];
            for(int i=start; i<length; i++){
                pressure_sensor.readRegs(i, data, 1); 
                switch(i){
                    case(0x00):
                        printf("0x%x: MPL_STATUS=0x%x\r\n",i,data[0]);
                        break;
                    case(0x01):
                        printf("0x%x: MPL_OUT_P_MSB=0x%x\r\n",i,data[0]);
                        break;
                    case(0x02):
                        printf("0x%x: MPL_OUT_P_CSB=0x%x\r\n",i,data[0]);
                        break;
                    case(0x03):
                        printf("0x%x: MPL_OUT_P_LSB=0x%x\r\n",i,data[0]);
                        break;
                    case(0x04):
                        printf("0x%x: MPL_OUT_T_MSB=0x%x\r\n",i,data[0]);
                        break;
                    case(0x05):
                        printf("0x%x: MPL_OUT_T_LSB=0x%x\r\n",i,data[0]);
                        break;
                    case(0x06):
                        printf("0x%x: MPL_DR_STATUS=0x%x\r\n",i,data[0]);
                        break;
                    case(0x07):
                        printf("0x%x: MPL_OUT_P_DELTA_MSB=0x%x\r\n",i,data[0]);
                        break;
                    case(0x08):
                        printf("0x%x: MPL_OUT_P_DELTA_CSB=0x%x\r\n",i,data[0]);
                        break;
                    case(0x09):
                        printf("0x%x: MPL_OUT_P_DELTA_LSB=0x%x\r\n",i,data[0]);
                        break;
                    case(0x0A):
                        printf("0x%x: MPL_OUT_T_DELTA_MSB=0x%x\r\n",i,data[0]);
                        break;
                    case(0x0B):
                        printf("0x%x: MPL_OUT_T_DELTA_LSB=0x%x\r\n",i,data[0]);
                        break;
                    case(0x0C):
                        printf("0x%x: MPL_WHO_AM_I=0x%x\r\n",i,data[0]);
                        break;
                    case(0x0D):
                        printf("0x%x: MPL_F_STATUS=0x%x\r\n",i,data[0]);
                        break;
                    case(0x0E):
                        printf("0x%x: MPL_F_DATA=0x%x\r\n",i,data[0]);
                        break;
                    case(0x0F):
                        printf("0x%x: MPL_F_SETUP=0x%x\r\n",i,data[0]);
                        break;
                    case(0x10):
                        printf("0x%x: MPL_TIME_DLY=0x%x\r\n",i,data[0]);
                        break;
                    case(0x11):
                        printf("0x%x: MPL_SYSMOD=0x%x\r\n",i,data[0]);
                        break;
                    case(0x12):
                        printf("0x%x: MPL_INT_SOURCE=0x%x\r\n",i,data[0]);
                        break;
                    case(0x13):
                        printf("0x%x: MPL_PT_DATA_CFG=0x%x\r\n",i,data[0]);
                        break;
                    case(0x14):
                        printf("0x%x: MPL_BAR_IN_MSB=0x%x\r\n",i,data[0]);
                        break;
                    case(0x15):
                        printf("0x%x: MPL_BAR_IN_LSB=0x%x\r\n",i,data[0]);
                        break;
                    case(0x16):
                        printf("0x%x: MPL_P_TGT_MSB=0x%x\r\n",i,data[0]);
                        break;
                    case(0x17):
                        printf("0x%x: MPL_P_TGT_LSB=0x%x\r\n",i,data[0]);
                        break;
                    case(0x18):
                        printf("0x%x: MPL_T_TGT=0x%x\r\n",i,data[0]);
                        break;
                    case(0x19):
                        printf("0x%x: MPL_P_WND_MSB=0x%x\r\n",i,data[0]);
                        break;
                    case(0x1A):
                        printf("0x%x: MPL_P_WND_LSB=0x%x\r\n",i,data[0]);
                        break;
                    case(0x1B):
                        printf("0x%x: MPL_T_WND=0x%x\r\n",i,data[0]);
                        break;
                    case(0x1C):
                        printf("0x%x: MPL_P_MIN_MSB=0x%x\r\n",i,data[0]);
                        break;        
                    case(0x1D):
                        printf("0x%x: MPL_P_MIN_CSB=0x%x\r\n",i,data[0]);
                        break;
                    case(0x1E):
                        printf("0x%x: MPL_P_MIN_LSB=0x%x\r\n",i,data[0]);
                        break;
                    case(0x1F):
                        printf("0x%x: MPL_T_MIN_MSB=0x%x\r\n",i,data[0]);
                        break;
                    case(0x20):
                        printf("0x%x: MPL_T_MIN_LSB=0x%x\r\n",i,data[0]);
                        break;
                    case(0x21):
                        printf("0x%x: MPL_P_MAX_MSB=0x%x\r\n",i,data[0]);
                        break;
                    case(0x22):
                        printf("0x%x: MPL_P_MAX_CSB=0x%x\r\n",i,data[0]);
                        break;
                    case(0x23):
                        printf("0x%x: MPL_P_MAX_LSB=0x%x\r\n",i,data[0]);
                        break;
                    case(0x24):
                        printf("0x%x: MPL_T_MAX_MSB=0x%x\r\n",i,data[0]);
                        break;
                    case(0x25):
                        printf("0x%x: MPL_T_MAX_LSB=0x%x\r\n",i,data[0]);
                        break;
                    case(0x26):
                        printf("0x%x: MPL_CTRL_REG1=0x%x\r\n",i,data[0]);
                        break;
                    case(0x27):
                        printf("0x%x: MPL_CTRL_REG2=0x%x\r\n",i,data[0]);
                        break;
                    case(0x28):
                        printf("0x%x: MPL_CTRL_REG3=0x%x\r\n",i,data[0]);
                        break;
                    case(0x29):
                        printf("0x%x: MPL_CTRL_REG4=0x%x\r\n",i,data[0]);
                        break;
                    case(0x2A):
                        printf("0x%x: MPL_CTRL_REG5=0x%x\r\n",i,data[0]);
                        break;
                    case(0x2B):
                        printf("0x%x: MPL_OFF_P=0x%x\r\n",i,data[0]);
                        break;
                    case(0x2C):
                        printf("0x%x: MPL_OFF_T=0x%x\r\n",i,data[0]);
                        break;
                    case(0x2D):
                        printf("0x%x: MPL_OFF_H=0x%x\r\n",i,data[0]);
                        break;
                    case(0x2E):
                        printf("0x%x: MPL_T_MIN_MSB=0x%x\r\n",i,data[0]);
                        break;
                    case(0x2F):
                        printf("0x%x: MPL_T_MIN_MSB=0x%x\r\n",i,data[0]);
                        break;
                }
            }      
            return 0; 
        }
        else{
            return -1;
        }
    }
}

//Solution entails 
char s[1];
int main() {
   
    dataPoints data[100];
   
    uint8_t id;
    pc.printf("\n\r*** MPL3115A2 Pressure/Altitude Sensor Test *** \n\r");
    while ((id=pressure_sensor.getID())!=0xC4) {
        pc.printf("Status read unsuccessful: Value = 0x%02x\n\r",id);
        pc.printf("Check wiring to the pressure sensor\n\r",id);
        pc.printf("Retesting for correct ID in 1 second...\n\r");
        wait(1);
    }
    //uint8_t tmp[2];
   //tmp[0] = 0x26;
//    pressure_sensor.readRegs(0x26, &tmp[1], 1);
//    tmp[1] = tmp[1] & 0xC6;
//    pressure_sensor.writeRegs(tmp,2);
    pc.printf("Status read successfully: Value = 0x%02x\n\r",id);
    pc.printf("***1hz readings from the pressure sensor***\n\r");
     
   int counter= 0;
    while(1) {    
     mpl3115_reg_print(0,0);
        //this is where I would check for the GPIO pin if implemented
        if(counter!=100){
            dataPoints p1 = {0,0}; 
           //pc.printf("%f hPA; %f m\n\r",pressure_sensor.getPressure(),pressure_sensor.getAltitude());
             p1.pres = pressure_sensor.getPressure();
             p1.alt = pressure_sensor.getAltitude();
            data[counter] = p1;
            //pc.printf("STORED VALUES: \n\r Pressure: %f hPA, Altitude: %f m\n\r",data[0].pres,data[0].alt);
            pc.printf("DATA STORED\n\r");
            if (pc.readable()){
                s[1]=pc.getc(); 
                if(s[1] == 'p'){
                    pc.printf("STORED VALUES: \n\r Pressure: %f hPA, Altitude: %f m\n\r",data[0].pres,data[0].alt);   
                for(int i=1; i<=counter; i++){    
                    pc.printf("Pressure: %f hPA, Altitude: %f m\n\r",data[i].pres,data[i].alt);
                    s[1] = 'x';
                            
                        }
                      }
                    }
                    
            
            //if the counter is going to go over the 100 limit reset it to zero and then 
            if(counter+1<=100){
                counter++;
            }
            else{
                counter=0;
            }
            myled = !myled;
            wait(1);
        }
        else{
            pc.printf("STORED VALUES: \n\r Pressure: %f hPA, Altitude: %f m\n\r",data[0].pres,data[0].alt);   
            for(int i=1; i<=counter; i++){    
                pc.printf("Pressure: %f hPA, Altitude: %f m\n\r",data[i].pres,data[i].alt);
            }
            for(int i=0; i<=100; i++){    
                data[i].pres=NULL;
                data[i].alt=NULL;
            }
            pc.printf("Cleared Data \n\r");
        }
  
    }


}
