#include "mbed.h"
#include "ADXL362.h"
DigitalOut led1(LED1);
 
// Interface pulled from ADXL362.cpp
// ADXL362::ADXL362(PinName CS, PinName MOSI, PinName MISO, PinName SCK) :
ADXL362 adxl362(PA_0,PA_7,PA_6,PA_1);



int adxl362_reg_print(int start, int length){
    typedef enum {
        DEVID_AD = 0x00,
        DEVID_MST = 0x01,
        PARTID = 0x02,
        REVID = 0x03,
        XDATA = 0x08,
        YDATA = 0x09,
        ZDATA = 0x0A,
        STATUS = 0x0B,
        FIFO_ENTRIES_L = 0x0C,
        FIFO_ENTRIES_H = 0x0D,
        XDATA_L = 0x0E,
        XDATA_H = 0x0F,
        YDATA_L = 0x10,
        YDATA_H = 0x11,
        ZDATA_L = 0x12,
        ZDATA_H = 0x13,
        TEMP_L = 0x14,
        TEMP_H = 0x15,
        // Reserved = 0x16;
        // Reserved = 0x17;
        SOFT_RESET = 0x1F,
        THRESH_ACT_L = 0x20,
        THRESH_ACT_H = 0x21,
        TIME_ACT = 0x22,
        THRESH_INACT_L = 0x23,
        THRESH_INACT_H = 0x24,
        TIME_INACT_L = 0x25,
        TIME_INACT_H = 0x26,
        ACT_INACT_CTL = 0x27,
        FIFO_CONTROL = 0x28,
        FIFO_SAMPLES = 0x29,
        INTMAP1 = 0x2A,
        INTMAP2 = 0x2B,
        FILTER_CTL = 0x2C,
        POWER_CTL = 0x2D,
        SELF_TEST = 0x2E,
    } ADXL362_register_t;
    
     char *regnames[34] = {"DEVID_AD","DEVID_MST","PARTID","REVID","XDATA","YDATA","ZDATA","STATUS","FIFO_ENTRIES_L",
                           "FIFO_ENTRIES_H","XDATA_L","XDATA_H","YDATA_L","YDATA_H","ZDATA_L","ZDATA_H","TEMP_L",
                           "TEMP_H","SOFT_RESET","THRESH_ACT_L","THRESH_ACT_H","TIME_ACT","THRESH_INACT_L","THRESH_INACT_H","TIME_INACT_L","TIME_INACT_H",
                           "ACT_INACT_CTL","FIFO_CONTROL","FIFO_SAMPLES","INTMAP1","INTMAP2","FILTER_CTL","POWER_CTL",
                           "SELF_TEST"};
     int val1[34] = { 0x00, 0x01,0x02,0x03,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F,0x10,0x11,0x12,0x13,0x14,0x15,0x1F,0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,0x2B,0x2C,0x2D,0x2E};
     if(0x00<=start && start <=0x2E){
         if(length>0){
             int j = 0;
             //uint8_t adreg = read_reg(ADXL362::DEVID_AD);
             for(int x = start; x<=length; x++){
                int val = val1[x];
                switch(val){
                    case(ADXL362::DEVID_AD):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x],val);
                        break;
                    case(ADXL362::DEVID_MST):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::PARTID):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::REVID):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::XDATA):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::YDATA):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::ZDATA):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::STATUS):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::FIFO_ENTRIES_L):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::FIFO_ENTRIES_H):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::XDATA_L):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::XDATA_H):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::YDATA_L):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::YDATA_H):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::ZDATA_L):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::ZDATA_H):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::TEMP_L):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::TEMP_H):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::SOFT_RESET):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::THRESH_ACT_L):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::THRESH_ACT_H):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::TIME_ACT):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::THRESH_INACT_L):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::THRESH_INACT_H):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::TIME_INACT_L):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::TIME_INACT_H):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::ACT_INACT_CTL):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::INTMAP1):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::INTMAP2):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::FILTER_CTL):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::POWER_CTL):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::SELF_TEST):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::FIFO_CONTROL):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::FIFO_SAMPLES):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    default: printf("test%0x", val);
                }
                j++;
            } 
         }
         else if(length==0){
            int j = 0;
            //uint8_t adreg = read_reg(ADXL362::DEVID_AD);
            for(int x = start; x<34; x++){
                          int val=val1[x];
                //printf("> %0x: %s=%0x \n\r", x, regnames[x],val);
                switch(val){
                    case(ADXL362::DEVID_AD):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x],val);
                        break;
                    case(ADXL362::DEVID_MST):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::PARTID):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::REVID):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::XDATA):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::YDATA):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::ZDATA):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::STATUS):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::FIFO_ENTRIES_L):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::FIFO_ENTRIES_H):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::XDATA_L):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::XDATA_H):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::YDATA_L):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::YDATA_H):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::ZDATA_L):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::ZDATA_H):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::TEMP_L):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::TEMP_H):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::SOFT_RESET):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::THRESH_ACT_L):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::THRESH_ACT_H):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::TIME_ACT):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::THRESH_INACT_L):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::THRESH_INACT_H):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::TIME_INACT_L):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::TIME_INACT_H):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::ACT_INACT_CTL):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::INTMAP1):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::INTMAP2):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::FILTER_CTL):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::POWER_CTL):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::SELF_TEST):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::FIFO_CONTROL):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                    case(ADXL362::FIFO_SAMPLES):
                        printf("0x%0x: %s=0x%0x \n\r", j, regnames[x], val);
                        break;
                        
                     default: printf("MISSING: test%0x\n\r", val);
                }
                j++;
             }
         }
         else{
            free(regnames);
            return 1;
         }
         free(regnames);
         return 0;
     }
     else{
         free(regnames);
         return 1;
     }
     
}


int main() {
    adxl362.reset();
    wait_ms(600); // we need to wait at least 500ms after ADXL362 reset
    adxl362.set_mode(ADXL362::MEASUREMENT);
    int8_t x,y,z; 
    
    int8_t current [3] = {0,0,0};
    int8_t accel [3] = {0,0,0};
    int8_t currAdd;
    int8_t diffAdd;
    float threshold = 2;
    float val;
    int knock_counter = 0;
    
        while(1) {
            x=adxl362.scanx_u8();
            y=adxl362.scany_u8();
            z=adxl362.scanz_u8();
             current [0] = x; 
             current [1] = y; 
             current [2] = z; 
             currAdd = abs(current[0] + current [1] + current [2]);
            wait_ms(10);
            x=adxl362.scanx_u8();
            y=adxl362.scany_u8();
            z=adxl362.scanz_u8();
                accel[0] = x;
                accel[1] = y;
                accel[2] = z;
                diffAdd = abs(accel[0] + accel [1] + accel [2]);
            wait_ms(10);
            val = abs(currAdd - diffAdd);
            
            if(val > threshold){
            printf("\n\r A knock has been heard ma dude\r\n");
            printf("Knocks = %d\r\n" , knock_counter);
             knock_counter ++;
             led1 = 1;
             wait_ms(2000);
             led1 = 0;
             }
          //  printf("x = %d y = %d z = %d\r\n",x,y,z);
        //wait_ms(1000);
        
       // adxl362_reg_print(0, 0);
    }
}