#include "mbed.h"
#include "MPL3115A2.h"
#include "string"
#include "ctype.h"
#include "ATParser.h"
#include "BufferedSerial.h"
#include "MyBuffer.h"
#include "TSL2561.h"
#include <cstdarg>
#include<stdio.h>
#include<math.h>

TSL2561 lightsensor(PB_7,PB_6);
DigitalOut led1(LED1);
Serial pc(SERIAL_TX, SERIAL_RX, 115200);
//Serial device(PA_9, PA_10, 115200);  // tx, rx


BufferedSerial serial = BufferedSerial(PA_9, PA_10);

DigitalOut myled(LED1);
MPL3115A2 pressure_sensor(PB_7,PB_6,0x60);

bool s = true;
char test[1];

struct dataPoints
{
   double pres;
   double temp;
 
};



double lux[50];
dataPoints data[100];



//function to join the network
int JoinNetwork(){
    
    
    pc.printf("attempting to join the network \n\r");
    serial.baud(115200);
    pc.printf("Buffered serial created \n\r");
    ATParser at = ATParser(serial, "\r\n" ,256, 8000, false);
    at.send("AT+NI=1,MTCDT-19400691");
    wait(1);
    if(at.recv("OK")){
        pc.printf("HEYO\n\r");
    } else {
        pc.printf("BOO.\n\r");
    }
    at.send("AT+NK=1,MTCDT-19400691");
    wait(1);
    if(at.recv("OK")){
        pc.printf("HEYO\n\r");
    } else {
        pc.printf("BOO.\n\r");
    }
    at.send("AT+FSB=1");
    wait(1);
    if(at.recv("OK")){
        pc.printf("HEYO\n\r");
    } else {
        pc.printf("BOO.\n\r");
    }
    at.send("AT+JOIN");
    wait(1);
    if(at.recv("OK")){
        pc.printf("HEYO\n\r");
        return 1;
    } else {
        pc.printf("BOO.\n\r");
        return 0;
    }

 }
 
 void Sdata(){
      ATParser at = ATParser(serial, "\r\n" ,256, 8000, false);
      serial.baud(115200);
      dataPoints p1 = {0,0}; 
      p1.temp = pressure_sensor.getTemperature();
      p1.pres = pressure_sensor.getPressure();
      double tempVal = p1.temp;
      double presVal = p1.pres;
      char tempStr[10];
      char presStr[10];
      sprintf(tempStr, "%f", tempVal);
      sprintf(presStr, "%f", presVal);
      at.send("AT+SEND=%0.5s,%0.5s", presStr,  tempStr);
    
     }
 
 void sendData(){
     dataPoints p1 = {0,0}; 
     int counter = 0; 
     int send = 1;
    while(1){
      ATParser at = ATParser(serial, "\r\n" ,256, 8000, false);
      serial.baud(115200);
     
     
        
/*    
    at.send("AT+NJS");
    wait(1);
    if(at.recv("1")){}
    else {
        JoinNetwork();
    }
  */      
        
        
        led1 = 1;
        double light = lightsensor.lux();
        pc.printf("light %f \n\r", light); 
        char luxStr[10];
        lux[counter] = light;
   
      pc.printf("lux val %f %d\n\r", lux[counter], counter); 
      counter++; 
    
      p1.temp = pressure_sensor.getTemperature();
      p1.pres = pressure_sensor.getPressure();
      double tempVal = p1.temp;
      double presVal = p1.pres;
      char tempStr[10];
      char presStr[10];
      sprintf(tempStr, "%f", tempVal);
      sprintf(presStr, "%f", presVal);
      at.send("AT+SEND=%0.5s,%0.5s", presStr,  tempStr);
      pc.printf("Pressure: %f hPA, temp: %f \n\r",presVal,tempVal);
      pc.printf("AT+SEND=%0.6s,%0.6s\0", presStr,  tempStr);
      wait(1);
    if(at.recv("OK")){
        pc.printf("data sent browski\n\r");
    } else { 
        pc.printf("That shit didnt send....rejoining network\n\r");
        while(!JoinNetwork());
        at.send("AT+SEND=%0.5s,%0.5s", presStr,  tempStr);
        pc.printf("sent again \n\r");
        }
        
          
         pc.printf("back to waiting \r");
      wait(3600);
  //dump light data every 24hrs    
      if(counter == 24){
       while(counter > 0){
         sprintf(luxStr, "%f", lux[counter]);
         wait(5);
        pc.printf("dumping light data: %s \n\r", luxStr);
         at.send("AT+SEND=%0.7s",  luxStr);
           if(at.recv("OK")){
        pc.printf("data sent browski\n\r");
    } else {
        pc.printf("That shit didnt send :(\n\r");
         while(!JoinNetwork());
          at.send("AT+SEND=%0.5s,%0.5s", presStr,  tempStr);
          pc.printf("sent again \n\r");
    }
         counter--;
       }
    }
  }
}
 
 
 


int main() {  

  //  serial.baud(115200);
  //  while(!JoinNetwork());
  //  pc.printf("Network Joined Successfully! \n\r");
  //  sendData();
    }
/*
    //pass through for tests and s press
    while(1 && s) {
    
        if (pc.readable()){
            test[0] = pc.getc();
            if(test[0] == 'S'){
                    pc.printf("GOT AN S");
                    Sdata();
            }
        }
    }
    sendData();
        
        if(pc.readable()) {
            serial.putc(pc.getc());
            myled = !myled;
        }
        if(serial.readable()) {
            pc.putc(serial.getc());
            myled = !myled;
        }
    }  
    */






