/*
  main.cpp
  2014 Copyright (c) Seeed Technology Inc.  All right reserved.

  Author:lawliet zou(lawliet.zou@gmail.com)
  2014-02-17

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "mbed.h"
#include "SeeedStudioTFTv2.h"
#include "Arial12x12.h"
#include "Arial24x23.h"
#include "Arial28x28.h"
#include "font_big.h"

#define PIN_XP          A3
#define PIN_XM          A1
#define PIN_YP          A2
#define PIN_YM          A0
#define PIN_MOSI        D11
#define PIN_MISO        D12
#define PIN_SCLK        D13
#define PIN_CS_TFT      D5
#define PIN_DC_TFT      D6
#define PIN_BL_TFT      D7
#define PIN_CS_SD       D4

typedef enum { YES, MAYBE, NO } TOUCH;

SeeedStudioTFTv2 TFT(PIN_XP, PIN_XM, PIN_YP, PIN_YM, PIN_MOSI, PIN_MISO, PIN_SCLK, PIN_CS_TFT, PIN_DC_TFT, PIN_BL_TFT, PIN_CS_SD);

void head() {

        TFT.set_font((unsigned char*) Arial12x12);
        //Time
        set_time(1387188323); // Set RTC time to 16 December 2013 10:05:23 UTC
        time_t seconds = time(NULL);
    
        //printf("Time as seconds since January 1, 1970 = %d\n", seconds);
        TFT.locate(150,0);
        char buffer[32];
        strftime(buffer, 32, "%I:%M:%S %p\n", localtime(&seconds));
        TFT.printf(buffer);
        //Print a welcome message
        
        TFT.locate(0,0);
        TFT.printf("Hello user");
    
}

void keypad() {
    
    TFT.cls();
    head();
    //Keypad
        TFT.circle(50,100,26,White);
        TFT.circle(50,160,26,White);
        TFT.circle(50,220,26,White);
        TFT.circle(120,100,26,White);
        TFT.circle(120,160,26,White);
        TFT.circle(120,220,26,White);
        TFT.circle(120,280,26,White);
        TFT.circle(190,100,26,White);
        TFT.circle(190,160,26,White);
        TFT.circle(190,220,26,White);
        TFT.circle(50,280,26,White);
        TFT.circle(190,280,26,White);
        TFT.circle(190,40,26,White);
        TFT.set_font((unsigned char*) Arial24x23);
        TFT.locate(40,84);
        TFT.printf("1");
        TFT.locate(40,144);
        TFT.printf("4");
        TFT.locate(40,204);
        TFT.printf("7");
        TFT.locate(110,84);
        TFT.printf("2");
        TFT.locate(110,144);
        TFT.printf("5");
        TFT.locate(110,204);
        TFT.printf("8");
        TFT.locate(180,84);
        TFT.printf("3");
        TFT.locate(180,144);
        TFT.printf("6");
        TFT.locate(180,204);
        TFT.printf("9");
        TFT.locate(110,264);
        TFT.printf("0");
        TFT.set_font((unsigned char*) Arial12x12);
        TFT.locate(110,104);
        TFT.printf("abc");
        TFT.locate(180,104);
        TFT.printf("def");
        TFT.locate(40,164);
        TFT.printf("ghi");
        TFT.locate(110,164);
        TFT.printf("jkl");
        TFT.locate(178,164);
        TFT.printf("mno");
        TFT.locate(36,224);
        TFT.printf("pqrs");
        TFT.locate(110,224);
        TFT.printf("tuv");
        TFT.locate(175,224);
        TFT.printf("wxyz");
        TFT.locate(110,284);
        TFT.printf("__");
        TFT.set_font((unsigned char*) Arial24x23);
        TFT.locate(40,270);
        TFT.printf("C");
        TFT.locate(180,270);
        TFT.printf("T");
        TFT.locate(180,27);
        TFT.printf("X");
        
      
}

void call() {
    
    TFT.cls();
        head();
        TFT.set_font((unsigned char*) Arial24x23);
        TFT.locate(50,280);
        TFT.printf("End Call ");
        TFT.line(40,270,190,270,White);
        TFT.line(40,310,190,310,White);
        TFT.line(40,270,40,310,White);
        TFT.line(190,270,190,310,White);
    
}

void text() {
    
    TFT.cls();
    head();
    TFT.circle(50,100,26,White);
        TFT.circle(50,160,26,White);
        TFT.circle(50,220,26,White);
        TFT.circle(120,100,26,White);
        TFT.circle(120,160,26,White);
        TFT.circle(120,220,26,White);
        TFT.circle(120,280,26,White);
        TFT.circle(190,100,26,White);
        TFT.circle(190,160,26,White);
        TFT.circle(190,220,26,White);
        TFT.circle(190,280,26,White);
        TFT.set_font((unsigned char*) Arial24x23);
        TFT.locate(40,84);
        TFT.printf("1");
        TFT.locate(40,144);
        TFT.printf("4");
        TFT.locate(40,204);
        TFT.printf("7");
        TFT.locate(110,84);
        TFT.printf("2");
        TFT.locate(110,144);
        TFT.printf("5");
        TFT.locate(110,204);
        TFT.printf("8");
        TFT.locate(180,84);
        TFT.printf("3");
        TFT.locate(180,144);
        TFT.printf("6");
        TFT.locate(180,204);
        TFT.printf("9");
        TFT.locate(110,264);
        TFT.printf("0");
        TFT.set_font((unsigned char*) Arial12x12);
        TFT.locate(110,104);
        TFT.printf("abc");
        TFT.locate(180,104);
        TFT.printf("def");
        TFT.locate(40,164);
        TFT.printf("ghi");
        TFT.locate(110,164);
        TFT.printf("jkl");
        TFT.locate(178,164);
        TFT.printf("mno");
        TFT.locate(36,224);
        TFT.printf("pqrs");
        TFT.locate(110,224);
        TFT.printf("tuv");
        TFT.locate(175,224);
        TFT.printf("wxyz");
        TFT.locate(110,284);
        TFT.printf("__");
        TFT.set_font((unsigned char*) Arial24x23);
        TFT.locate(180,270);
        TFT.printf("S");
        TFT.line(5,20,235,20,White);
        TFT.line(5,65,235,65,White);
        TFT.line(5,20,5,65,White);
        TFT.line(235,20,235,65,White);
    
}


int main()
{
        int curr_x = 20;
        int curr_y = 5;
        int flag = 100;
        //Configure the display driver
        TFT.background(Black);
        TFT.foreground(White);
        TFT.cls();
        point p;
        keypad();
        char number[10];
        int in = 0;
        int j = 0;
        printf("HELLO SCA<M\n");
        while(1) {
            TFT.set_font((unsigned char*) Arial24x23);
            while(TFT.getTouch(p) != YES && TFT.getTouch(p) != MAYBE);
            
            while (TFT.getTouch(p) != NO && TFT.getTouch(p) != MAYBE) {
                
                    //TFT.locate(50, 20);
                    //TFT.printf("%i %i",p.x,p.y);
                   
                    if((2000 < p.x && p.x < 3100) && (1500 < p.y && p.y < 2800)) {
                        flag = 1;
                        
                    }
                    else if((2000 < p.x && p.x < 3100) && (3300 < p.y && p.y < 4800)) {
                        flag = 2;
                        
                    }
                    else if((2000 < p.x && p.x < 3100) && (5300 < p.y && p.y < 6800)) {
                        flag = 3;
                        
                    }
                    else if((3300 < p.x && p.x < 4400) && (1500 < p.y && p.y < 2800))  {
                        flag = 4;
                        
                    }
                    else if((3300 < p.x && p.x < 4400) && (3300 < p.y && p.y < 4800)) {
                        flag = 5;
                    }
                    else if((3300 < p.x && p.x < 4400) && (5300 < p.y && p.y < 6800)) {
                        flag = 6;
                        
                    }
                    else if((4600 < p.x && p.x < 5700) && (1500 < p.y && p.y < 2800)) {
                        flag = 7;
                       
                    }
                    else if((4600 < p.x && p.x < 5700) && (3300 < p.y && p.y < 4800)) {
                        flag = 8;
                       
                    }
                    else if((4600 < p.x && p.x < 5700) && (5300 < p.y && p.y < 6800)) {
                        flag = 9;
                        
                    }
                    else if((5800 < p.x && p.x < 6900) && (3300 < p.y && p.y < 4800)) {
                        flag = 0;
                        
                    }
                    else if((5800 < p.x && p.x < 6900) && (1500 < p.y && p.y < 2800)) {
                        flag = 10;
                        
                    }
                    else if((5800 < p.x && p.x < 6900) && (5300 < p.y && p.y < 6800)) {
                        flag = 11;
                        
                    } 
                    else if((1000 < p.x && p.x < 2000) && (5300 < p.y && p.y < 6800)) {
                        flag = 20;
                    } 
                    else
                        flag = 100;
            }
            
            TFT.locate(curr_y,curr_x);
            if (flag == 1) {
                
                TFT.printf("%i",flag);
                curr_y += 15;
                number[in++] = flag;
                wait_ms(30);
                
            }
            else if (flag == 2) {
               
                TFT.printf("%i",flag);
                curr_y += 15;
                 number[in++] = flag;
                wait_ms(30);
            }
            else if (flag == 3) {
                number[in++] = flag;
                TFT.printf("%i",flag);
                curr_y += 15;
                wait_ms(30);
            }
            else if (flag == 4) {
               
                TFT.printf("%i",flag);
                curr_y += 15;
                 number[in++] = flag;
                wait_ms(30);
            }
            else if (flag == 5) {
                
                TFT.printf("%i",flag);
                curr_y += 15;
                number[in++] = flag;
                wait_ms(30);
            }
            else if (flag == 6) {
                
                TFT.printf("%i",flag);
                curr_y += 15;
                number[in++] = flag;
                wait_ms(30);
            }
            else if (flag == 7) {
                
                TFT.printf("%i",flag);
                curr_y += 15;
                number[in++] = flag;
                wait_ms(30);
            }
            else if (flag == 8) {
                
                TFT.printf("%i",flag);
                curr_y += 15;
                number[in++] = flag;
                wait_ms(30);
            }
            else if (flag == 9) {
                
                TFT.printf("%i",flag);
                curr_y += 15;
                number[in++] = flag;
                wait_ms(30);
            }
            else if (flag == 0) {
                
                TFT.printf("%i",flag);
                curr_y += 15;
                number[in++] = flag;
                wait_ms(30);
            }
            else if (flag == 20) {
                
                if(curr_y > 5){
                    curr_y -= 15;
                    TFT.locate(curr_y,curr_x);
                    TFT.printf(" ");
                    if (in > 0)
                    in--;
                }
                wait_ms(30);
            }
            else if (flag == 10) {
                for (j=0;j<in;j++)
                    printf("%i",number[j]);
            }
            else {
            }
        }
        
        /*
        head();
        
        
        TFT.locate(50,280);
        TFT.printf("Call/Text");
        TFT.line(40,270,190,270,White);
        TFT.line(40,310,190,310,White);
        TFT.line(40,270,40,310,White);
        TFT.line(190,270,190,310,White);
        
        
        wait(5);
        keypad();
        
        wait(5);
        call();
        wait(5);
        text();
        wait(5);     
        */
        //Draw some graphics
        //TFT.cls();
        //TFT.set_font((unsigned char*) Arial24x23);
        //TFT.locate(100,100);
        //TFT.printf("Graphic");
    
        //TFT.line(0,0,100,0,White);
        //TFT.line(0,0,0,200,White);
        //TFT.line(0,0,100,200,White);
        //TFT.line(0,0,100,200,White);
    
        /*TFT.rect(100,50,150,100,Red);
        TFT.fillrect(180,25,220,70,Blue);*/
    
       
    /*
        double s;
        for (int i = 0; i < 320; i++) {
            s = 20 * sin((long double)i / 10);
            TFT.pixel(i, 100 + (int)s, Red);
        }
    
        //Wait for 5 seconds
        wait(5.0);
    
        //Multiple fonts
        TFT.foreground(White);
        TFT.background(Blue);
        TFT.cls();
        TFT.set_font((unsigned char*) Arial24x23);
        TFT.locate(0,0);
        TFT.printf("Different Fonts:");
        TFT.set_font((unsigned char*) Neu42x35);
        TFT.locate(0,30);
        TFT.printf("Hello Mbed 1");
        TFT.set_font((unsigned char*) Arial24x23);
        TFT.locate(20,80);
        TFT.printf("Hello Mbed 2");
        TFT.set_font((unsigned char*) Arial12x12);
        TFT.locate(35,120);
        TFT.printf("Hello Mbed 3");*/
    
}
