#include "mbed.h"

#include <time.h>
#include <stdlib.h>
#include <stdio.h>

#include "comm.h"

PwmOut carrier(PTA5);
Serial TX(PTC4,PTC3);
Serial RX(PTE22, PTE23);
Serial pc(USBTX,USBRX);
DigitalOut whiteleds(PTB0);
DigitalOut red_led(PTE29);
DigitalOut green_led(PTE21);
DigitalOut blue_led(PTE20);
DigitalOut buzzer(PTA4);
void ActivateTarget();
Timer t;
Timer led;



int n;  //Random Number
bool activate = 0;
//char* buffer =new char[0,0,0];  //to be sent to scoreboard
char trash; //trash buffer
bool game_on = 0;
bool game_pause = 0;
//char* RxBuffer;



int main()
{
    commInit(4);
    char* txBuffer = new char[4];
    char* rxBuffer = new char[4];
    int shot = 0;
//
//








    char c;
    pc.printf("start\n\r");
    red_led = 0;
    green_led = 0;
    blue_led = 0;

    //set up the twp ports
    RX.baud(1000);
    TX.baud(1000);
    carrier.period(1.0/38000.0);
    carrier=0.5;
    //bool has_been_shot = 0;


    while(1) {
        if (led.read() >5) {
            red_led = 0;
            green_led = 0;
            blue_led = 0;
            shot = 0;
            led.stop();
            led.reset();
        }
        //remove any residual value from IR receiver before activation
        if(commRead(rxBuffer)) {
            commSetAck(txBuffer);
            pc.printf("Refreshing acknowledge buffer \n\r");
            switch(rxBuffer[0]) {
                case 0: //code to be executed on start signal e.g. game = true
                    game_on = 1;
                    game_pause = 0;
                   pc.printf("Start command\n\r");
                    break;
                case 1: // code to be executed on a get hits request, probably nothing
                    printf("Getting polled");
                    for(int i = 0; i < 4; i++) {
                       pc.printf("data %d: %d\n\r", i, txBuffer[i]);
                    }
                    break;
                case 2: // code to be executed on end signal e.g. game = false
                    game_on = 0;
                    game_pause = 0;
                    txBuffer = new char[0,0,0,0];
                    break;
                case 3: // code to be executed on pause signal e.g. pause = true
                    game_on = 1;
                    game_pause = 1;
                    break;
                case 4: // code to be executed on resume signal e.g. pause = false
                    game_on = 1;
                    game_pause = 0;
                    break;
                default: // code to be executed if code not identified
                    /*game_on = 0;
                    game_pause = 0;
                    break;
                    */
            }
        }
        if (game_on == 1 && game_pause == 0) {

            if(RX.readable()) {
                trash = RX.getc();
            }

            if(!activate && !shot) {
                ActivateTarget();
            }

            if(activate && t.read() <= 10) {
                
              




                if(RX.readable() && whiteleds == 1) {
                    c=RX.getc();
                } 
                else c=46;

                if (c != 46) {

                    if(c == 'B') { // 'B', gun3
                        whiteleds = 0;
                        txBuffer[0]++;
                        red_led = 1;
                        buzzer = 1;
                        shot = 1;
                        activate = 0;
                        led.start();
                        TX.putc(52);

                    }

                    if(c == 'a') { //'a', gun2
                        whiteleds = 0;
                        txBuffer[1]++;
                        blue_led =1;
                        buzzer = 1;
                        shot = 1;
                        activate = 0;
                        led.start();
                        TX.putc(52);

                    }
                    if(c == 'z') { //'z', gun1
                        whiteleds = 0;
                        txBuffer[2]++;
                        green_led = 1;
                        buzzer = 1;
                        shot = 1;
                        activate = 0;
                        led.start();
                        TX.putc(52);

                    }
                    // while(RX.readble()) c=RX.getc();

                    // transmit id
                    // has_been_shot = 1;

                    activate = 0;
                    //shine rgb LEDS
                    printf("%c\n\r", c );




                }

                //has_been_shot = 0;
            if(c != 46)                pc.putc(c); 

            }
            if(t.read() > 10) {
                whiteleds = 0;
                activate = 0;
            }
        }
    }

}




void ActivateTarget()
{
    //shine LEDs
    srand(time(NULL));
    n = rand();
//   k = n%10;
    //intf("%i\n\r",n%10);
    if(n%10 == 0) {

        whiteleds = 1;
        activate = 1;

        t.reset();
        t.start();


    } else {
        whiteleds = 0;

    }

}