#include "mbed.h"
#include "MMA8451Q.h"

void fireGun();
void disableState();
void checkForReload();
void reload();
void updateShotLEDs();

PwmOut carrier(PTE20);
Serial TX(PTE22,NC);

int16_t data[3];

DigitalIn trigger(PTB8);
DigitalOut onBoardLEDred(LED_RED);
DigitalOut onBoardLEDgreen(LED_GREEN);
DigitalOut gnd(PTB11);

DigitalOut shot[10] = {PTC0,PTC3,PTC4,PTC5,PTC6,PTC10,PTC11,PTC12,PTC13,PTC16};
DigitalOut pos(PTC7);

DigitalIn disableGun(PTE1);
DigitalOut gnd2(PTD7);
DigitalOut pos2(PTD6);

DigitalOut buzzer(PTE5);
DigitalOut gnd3(PTE4);



int shotsloaded;
bool triggerPressed;
char id;
int disableCounter;
MMA8451Q acc(PTE25, PTE24);


int main()
{

    gnd = 0;
    gnd2 = 0;
    gnd3 = 0;
    pos = 1;
    pos2 = 1;

    TX.baud(1000);
    id = 'B';
    carrier.period(1.0/38000.0);
    carrier=0.5f;

    shotsloaded = 10;
    updateShotLEDs();



    while(true) {

        if(disableGun) {

            // make the board LED red
            onBoardLEDred = 0;
            onBoardLEDgreen = 1;


            disableState();

        }

        // make the board LED green
        onBoardLEDred = 1;
        onBoardLEDgreen = 0;

        checkForReload();


        if(!trigger && shotsloaded != 0) {
            shotsloaded--;
            updateShotLEDs();
            fireGun();
        }



    }
}


void fireGun()
{

    // Fire!!!!!!!

    carrier=0.5f;

    TX.putc(id);

    buzzer = 1;
    wait(0.02f);
    buzzer = 0;
    wait(0.02f);

    TX.putc(id);

    buzzer = 1;
    wait(0.02f);
    buzzer = 0;
    wait(0.02f);

    TX.putc(id);

    buzzer = 1;
    wait(0.02f);
    buzzer = 0;
    wait(0.02f);

    TX.putc(id);

    carrier=0.0f;

    wait(0.08f);

}



void checkForReload()
{

    if(shotsloaded==0) {
        acc.getAccAllAxis(data);

        if(  abs( (((float) data[0])/ 16384)) >= 1.95f  ) {

            reload();

        }
    }
}

void reload()
{

    buzzer = 1;
    wait(0.08f);
    buzzer = 0;
    wait(0.05f);

    buzzer = 1;
    wait(0.08f);
    buzzer = 0;

    for(int i=1; i<=10; i++) {
        shotsloaded = (int) i;
        updateShotLEDs();
        wait(0.08f);
    }
}



void disableState()
{

    // While disabled make bar LEDs go up and down
    disableCounter = 0;
    while(disableGun) {

        for(int i=0; i<10; i++) {
            shot[i] = (i==disableCounter || i==(19-disableCounter))? 0 : 1 ;
        }

        disableCounter++;
        if(disableCounter==20) {
            disableCounter = 0;
        }
        wait(0.05f);

    }
    
    
    updateShotLEDs();
}



void updateShotLEDs()
{

    for(int i=0; i<10; i++) {
        shot[i] = (i<shotsloaded)? 0 : 1;
    }

}