#include "mbed.h"
#include "LCDTFT.h"
#include "Ranger.h"
#include "8x8.h" // sub to deal wtih teh 8x8 display


// pins for TFT
BusOut MyBus(PTA13,PTD5,PTD4,PTA12,PTA4,PTA5,PTC8,PTC9); // 8 bit bus on these dvices
LCDTFT     MyLCD(PTB0,PTB1,PTB2,PTB3,PTC2,&MyBus);//LCDTFT(PinName PIN_RD,PinName PIN_WR,PinName PIN_RS,PinName PIN_CS,PinName PIN_RESET, BusOut *BUSLCD);

PwmOut buzz(PTE31);



//wolf whistle
void wolf(int wt)
{
    int freq;
    int periodus=0;
    buzz=0; // quiet

    buzz.period_us(1e6/50);
    buzz=0.5; // 50% duty = max volume
    for(freq=50; freq<1200; freq=freq+20) {
        periodus=(int)(1e6/freq);
        buzz.period_us(periodus);
        wait_ms(wt);
    }
    buzz=0;
    wait(0.5);
    buzz=0.5; // 50% duty = max volume
    for(freq=1200; freq>50; freq=freq-5) {
        periodus=(int)(1e6/freq);
        buzz.period_us(periodus);
        wait_ms(wt);
    }
    buzz=0;



}

void wface(int eye,int mth)
{
    int ct=0;
    for(ct=1; ct<5; ct++) { // display the smiley for 800 times
        write_8x8(eye,mth);
    }//endforct
}

void sendtop()
{
    MyLCD.vLCDTFTFillScreen(White);
    MyLCD.vLCDTFTSetParametersPrintf(3,3,3,300,3,Blue,White);
    MyLCD.printf("Internet\n       of\n          THINGS!");

    MyLCD.vLCDTFTSetParametersPrintf(3,80,3,300,2,Red,White);
    MyLCD.printf("Starts 7th & 8th Week\n");
    MyLCD.vLCDTFTSetParametersPrintf(3,100,3,300,3,Black,White);
    MyLCD.printf("    Monday LR3 9am ");

}

void sendclose()
{
    MyLCD.vLCDTFTFillScreen(White);
    MyLCD.vLCDTFTSetParametersPrintf(3,3,3,300,3,Red,White);
    MyLCD.printf("Too...\n");

    MyLCD.vLCDTFTSetParametersPrintf(3,80,3,300,3,Purple,White);
    MyLCD.printf(".....Close\n");

}

Timer ev;

int main()
{
    ev.reset();
    ev.start();
    int clos=0,omesg=0; // var used to detect if they got too close!!!!
    int ct=0,test=0,eye=0,mth=0,newmesg=0,mesg=0; // newmessg detects new lcd text, messg is index of text in messages[]
    //each message is 8 chars and hence messg=0 is first message, messg=8 is second etc

    int cti=0,state=0; // face = value of smilie to display and state is the control variable that sets upo response based on range
    int rangecm=0,scount=0; //  scount used to select which event in a particular state is running;

    char messages[64];//|       |       |       |       |       |       |       |
    sprintf(messages,  "        Zzzzz...   Hiya  Helloo? Bored.. ARGHH!! Byee...");
    char message[8];
    MyLCD.vLCDTFTInit(1); // setup TFT display
    sendtop();
    wolf(5);
    buzz.period_ms(1);
    buzz=0;
    mesg=0;
    newmesg=1;
    for(ct=1;ct<50;ct++){
    wface(0,0);
    }
    
    while(1==1) {
        rangecm=range(); // get the range
//0 happy
//1 sad
//2 sleeping
//3 shouting
//4 winking
//5 looking left
// 6 looking right
// 7 evil
        if(rangecm >110) state=0;  //      nobody about - sleeping

        if(rangecm<110) state=1;  // somebody there looking left and right
        if (rangecm<70) state=2; // hello

        if (rangecm<50) state=3; // watch out warning
        if (rangecm<25) state=4;// TOO CLOSE ALARM


        wface(eye,mth);
        switch(state) {
            case 0:
                eye=3; // shuteye
                if(scount==0) {
                    mth=4; // open = snoring
                    buzz=0.5;
                    buzz.period_ms(250);
                    if(mesg!=8) {
                        mesg=8;
                        newmesg=1;
                    }//endif mesg
                }
                //endif scount
                else {
                    mth=2; // netural
                    buzz=0;
                    if(mesg!=0) {
                        mesg=0;
                        newmesg=1;
                    }//endif mesg
                }
                break;
            case 1:
                if(scount%2==0) eye=0; //look left
                else eye=2; //look right
                mth=2; //neutral
                buzz=0;
                if(mesg!=24) {
                    mesg=24;
                    newmesg=1;
                }//endif mesg
                break;
            case 2:
                if(scount==0) eye=3; // blink
                else eye=1; // look mid
                mth=0;
                buzz=0;
                if(mesg!=16) {
                    mesg=16;
                    newmesg=1;
                }//endif mesg
                break;
            case 3:
                if(scount==0) eye=3;
                else eye=5;
                mth=2;
                buzz=0;
                if(mesg!=32) {
                    mesg=32;
                    newmesg=1;
                }//endif mesg
                break;
            case 4:
                if(scount==0) eye=3;
                else eye=5;
                mth=1;
                buzz=0.5;
                buzz.period_ms(rangecm);
                if(mesg!=40) {
                    mesg=40;
                    clos=1;
                    newmesg=1;
                }//endif mesg
                break;
        }
        if(newmesg==1) {
            if(clos==1) {
                sendclose();
                clos=0;
                omesg=40;
                }
            if(mesg>0) {
                if(omesg==40 && state !=4) {
                    sendtop();
                    omesg=mesg;
                    }
                for(ct=0; ct<8; ct++) {
                    message[ct]=messages[ct+mesg];
                }
                MyLCD.vLCDTFTSetParametersPrintf(3,160,3,300,4,Orange,White);
                MyLCD.printf("%s ",message);
            } else {
                MyLCD.vLCDTFTSetParametersPrintf(3,160,3,300,4,Orange,White);
                MyLCD.printf("            ");
            }
            newmesg=0;

        }
        cti=ev.read(); //scount switch for snoring etc
        if(cti%3==0 && test==0) {
            scount=(scount+1)%4;
            test=cti;
        }
        if(cti>test) test=0;

        //  MyLCD.printf("%d  ",scount);

        //sub to write char/..??
        wface(eye,mth);




    }//endwhile
}//endmain
