// example to test the TFT Display from Mikroelectronika

#include "stdio.h"
#include "mbed.h"
#include "SPI_TFT_ILI9341.h"
#include "string"
#include "Arial12x12.h"
#include "Arial24x23.h"
#include "Arial28x28.h"
#include "font_big.h"


Serial pc (USBTX,USBRX);




// the display has a backlight switch on board
DigitalOut LCD_LED(PTA13);   // may not be needed on mikroelectronika board
DigitalOut pwr(PTD7); // ditto

// the TFT is connected to SPI pin 5-7
//SPI_TFT_ILI9341 TFT(p5, p6, p7, p8, p9, p10,"TFT"); // mosi, miso, sclk, cs, reset, dc for lpc1768
SPI_TFT_ILI9341 TFT(PTD2, PTD3, PTD1, PTD5, PTD0, PTA13,"TFT"); // mosi, miso, sclk, cs, reset, dc for frdmkl25z
//NB better combination to use a coherent 2x4 block for lcd
//   SPI_TFT_ILI9341 TFT(PTD2, PTD3, PTD1, PTA16, PTA17, PTC16,"TFT"); // mosi, miso, sclk, cs, reset, dc for frdmkl25z
//   DigitalOut LCD_LED(PTC17);
int touching=0;

// Subroutine to read the x location of the touch point
// need to set x+ to 3V and ground x- then read analogue voltage on ym
//nb need to add a check for actual touch as opposed to random crap
int readX()
{
    int delta=0,xv1=0,xv2=0,k=0;

    AnalogIn yp(PTB3);
    AnalogIn ym(PTB2);
    DigitalOut xp(PTB0);
    DigitalOut xm(PTB1);

    xp=1; // set positive sdie of x high
    xm=0;
    // dont need to do anyhting to set low side as it should be fine.
    // but do need to disconnect yp
    //yp.PinMode(PullNone)
    for(k=0; k<10; k++) { // make 10 readings to average
        xv1+=(int)ym.read_u16();  // get value
        xv2+=(int)yp.read_u16(); // get other value
    }
    delta=abs(xv2-xv1)/10;
    if(delta<300) touching=1;
    else touching=0;
    pc.printf("delta=%d \t %d\n\r",delta,touching);
    xp=0;
    xm=0;
    return(xv2/10); //maybe better to return the average of both....
}
// subroutine to read y values - has different pin functions ..
int readY()
{
    DigitalOut yp(PTB3);
    DigitalOut ym(PTB2);
    AnalogIn xp(PTB0);
    AnalogIn xm(PTB1);

    yp=1; // set positive sdie of x high
    ym=0;
    // dont need to do anyhting to set low side as it should be fine.
    // but do need to disconnect yp
    //yp.PinMode(PullNone)
    int yval=(int)xm.read_u16();  // get value

    yp=0;
    ym=0;
    return(yval);

}

void drawbuttons()
{
    TFT.fillrect(0,0,50,50,Red);
    TFT.fillrect(50,0,100,50,Green);
    TFT.fillrect(100,0,150,50,Blue);
    TFT.fillrect(150,0,200,50,White);
    TFT.fillrect(200,0,240,50,Black);

    TFT.rect(0,0,50,50,White);
    TFT.rect(50,0,100,50,White);
    TFT.rect(100,0,150,50,White);
    TFT.rect(150,0,200,50,White);
    TFT.rect(200,0,240,50,White);

}


int main()
{
    pc.baud(115200);
    int color=0;
    int xpos=0,ypos=0,xp=0,yp=0,sw=0;;
    pwr=1;
    wait(0.2);

    int i;
    LCD_LED = 1;            // backlight on

    TFT.claim(stdout);        // send stdout to the TFT display
    TFT.set_orientation(1);
    TFT.background(Black);    // set background to black
    TFT.foreground(White);    // set chars to white
    TFT.cls();                // clear the screen

    //first show the 4 directions
    TFT.set_orientation(0);
    TFT.background(Black);
    TFT.cls();

    TFT.set_font((unsigned char*) Arial12x12);
    TFT.locate(0,0);
    printf(" 0 Hello Mbed 0");
    TFT.set_orientation(1);
    TFT.locate(0,0);
    printf(" 1 Hello Mbed 1");
    TFT.set_orientation(2);
    TFT.locate(0,0);
    printf(" 2 Hello Mbed 2");
    TFT.set_orientation(3);
    TFT.locate(0,0);
    printf(" 3 Hello Mbed 3");
    TFT.set_orientation(3);
    TFT.set_font((unsigned char*) Arial24x23);
    TFT.locate(50,100);
    TFT.printf("TFT orientation 3");
    TFT.set_orientation(0);

    for(i=0; i<10; i++) {
        wait(0.2);        // wait one seconds
        TFT.locate(50,160);
        TFT.printf("count %d",i);
    }
    TFT.set_orientation(0);
    TFT.cls();
    //   LCD_LED = 1;
    //cornwer markers
    //TFT.fillcircle(10,10,5,0xffff);
    //TFT.fillcircle(230,10,5,0xffff);
    //TFT.fillcircle(230,310,5,0xffff);
    //TFT.fillcircle(10,310,5,0xffff);
    drawbuttons();
    while(1==1) {

        xpos=readX();
        ypos=readY();
        // top chunk of the screen is the button area //
        // 0<y<50 is palette area //

        //pc.printf("xpos=%d\t,\typo=%d",xpos,ypos);
        xp=(240*(xpos-5800))/51200;
        yp=320-(320*(ypos-3000))/58300;
        if(touching==1) pc.printf("\txp=%d\t,\typo=%d\n\r",xp,yp);
        if(xp>5 && yp>50 && touching==1) TFT.fillcircle(xp,yp,2,color);
        if(yp<50) { // color buttons
            sw=(int)xp/50;
            switch(sw) {
                case 0:
                    color=0xf800;
                    break;
                case 1:
                    color=0x07e0;
                    break;
                case 2:
                    color=0x001f;
                    break;
                case 3:
                    color=0xffff;
                    break;
                case 4:
                    color=0x0000;
                    TFT.cls();
                    drawbuttons();
                    break;
            }
            //  if(xp<50) color=0xF800;
            //   if(50<xp && xp<100) color=0x07e0;
            // if(xp>100 && xp<150) color=0x001f;
        }

        wait(0.1);

    }

}
