// example to test the TFT Display from Mikroelectronika

#include "stdio.h"
#include "mbed.h"
#include "SPI_TFT_ILI9341.h"
#include "string"
#include "Arial12x12.h"
#include "Arial24x23.h"
#include "Arial28x28.h"
#include "font_big.h"


Serial pc (USBTX,USBRX);




// the display has a backlight switch on board
DigitalOut LCD_LED(PTA13);   // may not be needed on mikroelectronika board
DigitalOut pwr(PTD7); // ditto

// the TFT is connected to SPI pin 5-7
//SPI_TFT_ILI9341 TFT(p5, p6, p7, p8, p9, p10,"TFT"); // mosi, miso, sclk, cs, reset, dc for lpc1768
SPI_TFT_ILI9341 TFT(PTD2, PTD3, PTD1, PTD5, PTD0, PTA13,"TFT"); // mosi, miso, sclk, cs, reset, dc for frdmkl25z
//NB better combination to use a coherent 2x4 block for lcd
//   SPI_TFT_ILI9341 TFT(PTD2, PTD3, PTD1, PTA16, PTA17, PTC16,"TFT"); // mosi, miso, sclk, cs, reset, dc for frdmkl25z
//   DigitalOut LCD_LED(PTC17);


// Subroutine to read the x location of the touch point
// need to set x+ to 3V and ground x- then read analogue voltage on ym
//nb need to add a check for actual touch as opposed to random crap
int readX()
{
    AnalogIn yp(PTB2);
    AnalogIn ym(PTB3);
    DigitalOut xp(PTB0);
    DigitalOut xm(PTB1);

    xp=1; // set positive sdie of x high
    xm=0;
    // dont need to do anyhting to set low side as it should be fine.
    // but do need to disconnect yp
    //yp.PinMode(PullNone)
    int xval=(int)ym.read_u16();  // get value
    return(xval);
}
// subroutine to read y values - has different pin functions ..
int readY()
{
    DigitalOut yp(PTB2);
    DigitalOut ym(PTB3);
    AnalogIn xp(PTB0);
    AnalogIn xm(PTB1);

    yp=1; // set positive sdie of x high
    ym=0;
    // dont need to do anyhting to set low side as it should be fine.
    // but do need to disconnect yp
    //yp.PinMode(PullNone)
    int yval=(int)xm.read_u16();  // get value
    return(yval);
}



int main()
{
    pc.baud(115200);

    int xpos=0,ypos=0,xp=0,yp=0;
    pwr=1;
    wait(0.2);

    int i;
    LCD_LED = 1;            // backlight on

    TFT.claim(stdout);        // send stdout to the TFT display
    TFT.set_orientation(1);
    TFT.background(Black);    // set background to black
    TFT.foreground(White);    // set chars to white
    TFT.cls();                // clear the screen

    //first show the 4 directions
    TFT.set_orientation(0);
    TFT.background(Black);
    TFT.cls();

    TFT.set_font((unsigned char*) Arial12x12);
    TFT.locate(0,0);
    printf(" 0 Hello Mbed 0");
    TFT.set_orientation(1);
    TFT.locate(0,0);
    printf(" 1 Hello Mbed 1");
    TFT.set_orientation(2);
    TFT.locate(0,0);
    printf(" 2 Hello Mbed 2");
    TFT.set_orientation(3);
    TFT.locate(0,0);
    printf(" 3 Hello Mbed 3");
    TFT.set_orientation(3);
    TFT.set_font((unsigned char*) Arial24x23);
    TFT.locate(50,100);
    TFT.printf("TFT orientation 3");
    TFT.set_orientation(1);
    for(i=0; i<10; i++) {
        wait(1);        // wait one seconds
        TFT.locate(50,160);
        TFT.printf("count %d",i);
    }
    TFT.set_orientation(1);
    TFT.cls();
    //   LCD_LED = 1;
    TFT.circle(120,120,10,0xffff);
    while(1==1) {

        xpos=readX();
        ypos=readY();
        pc.printf("xpos=%d\t,\typo=%d",xpos,ypos);
        xp=(240*xpos)/60000;
        yp=(320*ypos)/60000;
        pc.printf("\txp=%d\t,\typo=%d\n\r",xp,yp);
        if(xp>5 && yp>5) TFT.circle(xp,yp,5,Yellow);
        wait(0.1);

    }

}
